% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/serve.R
\name{serve_savedmodel}
\alias{serve_savedmodel}
\title{Serve a SavedModel}
\usage{
serve_savedmodel(model_dir, host = "127.0.0.1", port = 8089,
  daemonized = FALSE, browse = !daemonized)
}
\arguments{
\item{model_dir}{The path to the exported model, as a string.}

\item{host}{Address to use to serve model, as a string.}

\item{port}{Port to use to serve model, as numeric.}

\item{daemonized}{Makes 'httpuv' server daemonized so R interactive sessions
are not blocked to handle requests. To terminate a daemonized server, call
'httpuv::stopDaemonizedServer()' with the handle returned from this call.}

\item{browse}{Launch browser with serving landing page?}
}
\description{
Serve a TensorFlow SavedModel as a local web api.
}
\examples{
\dontrun{
# serve an existing model over a web interface
tfdeploy::serve_savedmodel(
  system.file("models/tensorflow-mnist", package = "tfdeploy")
)
}
}
\seealso{
\code{\link[=export_savedmodel]{export_savedmodel()}}
}
