% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hparams.R
\name{hparams_hparam}
\alias{hparams_hparam}
\title{Defines a HParam}
\usage{
hparams_hparam(name, domain = NA, display_name = name, description = name)
}
\arguments{
\item{name}{Name of the hyperparameter.}

\item{domain}{A list of values that can be assumed by the hyperparameter.
It can be \code{character()}, \code{numeric()} or \code{logical()} vector. You can also
pass a named numeric vector with eg \code{c(min_value = 0, max_value = 10)} in
this case, any value in this range is accepted.}

\item{display_name}{Display name of the hparameter for the TensorBoard UI.
By default it's identical to the name.}

\item{description}{Parameter description. Shown in tooltips around the
TensorBoard UI.}
}
\value{
A \code{hparams_hparam} object.
}
\description{
Hparam object are used to describe names and domains of hyperparameters so
TensorBoard UI can show additional information about them.
}
\note{
A list of \code{hparam} values can be passed to \code{\link[=log_hparams_config]{log_hparams_config()}} so
you define the hyperparameters that are tracked by the experiment.
}
\examples{
hparams_hparam("optimizer", domain = c("adam", "sgd"))
hparams_hparam("num_units", domain = c(128, 512, 1024))
hparams_hparam("use_cnn", domain = c(TRUE, FALSE))
hparams_hparam("dropout", domain = c(min_value = 0, max_value = 0.5))
}
