% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mcmc-kernels.R
\name{mcmc_metropolis_hastings}
\alias{mcmc_metropolis_hastings}
\title{Runs one step of the Metropolis-Hastings algorithm.}
\usage{
mcmc_metropolis_hastings(inner_kernel, seed = NULL, name = NULL)
}
\arguments{
\item{inner_kernel}{\code{TransitionKernel}-like object which has \code{collections$namedtuple}
\code{kernel_results} and which contains a \code{target_log_prob} member and optionally a \code{log_acceptance_correction} member.}

\item{seed}{integer to seed the random number generator.}

\item{name}{string prefixed to Ops created by this function. Default value: \code{NULL} (i.e., "mh_kernel").}
}
\value{
a Monte Carlo sampling kernel
}
\description{
The Metropolis-Hastings algorithm is a Markov chain Monte Carlo (MCMC) technique which uses a proposal distribution
to eventually sample from a target distribution.
}
\details{
Note: \code{inner_kernel$one_step} must return \code{kernel_results} as a \code{collections$namedtuple} which must:
\itemize{
\item have a \code{target_log_prob} field,
\item optionally have a \code{log_acceptance_correction} field, and,
\item have only fields which are \code{Tensor}-valued.
}

The Metropolis-Hastings log acceptance-probability is computed as:\preformatted{log_accept_ratio = (current_kernel_results.target_log_prob
                   - previous_kernel_results.target_log_prob
                   + current_kernel_results.log_acceptance_correction)
}

If \code{current_kernel_results$log_acceptance_correction} does not exist, it is
presumed \code{0} (i.e., that the proposal distribution is symmetric).
The most common use-case for \code{log_acceptance_correction} is in the
Metropolis-Hastings algorithm, i.e.,\preformatted{accept_prob(x' | x) = p(x') / p(x) (g(x|x') / g(x'|x))
where,
p  represents the target distribution,
g  represents the proposal (conditional) distribution,
x' is the proposed state, and,
x  is current state
}

The log of the parenthetical term is the \code{log_acceptance_correction}.
The \code{log_acceptance_correction} may not necessarily correspond to the ratio of
proposal distributions, e.g, \code{log_acceptance_correction} has a different
interpretation in Hamiltonian Monte Carlo.
}
\seealso{
Other mcmc_kernels: 
\code{\link{mcmc_dual_averaging_step_size_adaptation}()},
\code{\link{mcmc_hamiltonian_monte_carlo}()},
\code{\link{mcmc_metropolis_adjusted_langevin_algorithm}()},
\code{\link{mcmc_no_u_turn_sampler}()},
\code{\link{mcmc_random_walk_metropolis}()},
\code{\link{mcmc_replica_exchange_mc}()},
\code{\link{mcmc_simple_step_size_adaptation}()},
\code{\link{mcmc_slice_sampler}()},
\code{\link{mcmc_transformed_transition_kernel}()},
\code{\link{mcmc_uncalibrated_hamiltonian_monte_carlo}()},
\code{\link{mcmc_uncalibrated_langevin}()},
\code{\link{mcmc_uncalibrated_random_walk}()}
}
\concept{mcmc_kernels}
