% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bijector-methods.R
\name{tfb_inverse}
\alias{tfb_inverse}
\title{Returns the inverse Bijector evaluation, i.e., \code{X = g^{-1}(Y)}.}
\usage{
tfb_inverse(bijector, y, name = "inverse")
}
\arguments{
\item{bijector}{The bijector to apply}

\item{y}{Tensor. The input to the "inverse" evaluation.}

\item{name}{name of the operation}
}
\value{
a tensor
}
\description{
Returns the inverse Bijector evaluation, i.e., \code{X = g^{-1}(Y)}.
}
\examples{
\donttest{
  b <- tfb_affine_scalar(shift = 1, scale = 2)
  x <- 10
  y <- b \%>\% tfb_forward(x)
  b \%>\% tfb_inverse(y)
}
}
\seealso{
Other bijector_methods: 
\code{\link{tfb_forward_log_det_jacobian}()},
\code{\link{tfb_forward}()},
\code{\link{tfb_inverse_log_det_jacobian}()}
}
\concept{bijector_methods}
