% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mcmc-kernels.R
\name{mcmc_random_walk_metropolis}
\alias{mcmc_random_walk_metropolis}
\title{Runs one step of the RWM algorithm with symmetric proposal.}
\usage{
mcmc_random_walk_metropolis(target_log_prob_fn, new_state_fn = NULL,
  seed = NULL, name = NULL)
}
\arguments{
\item{target_log_prob_fn}{Function which takes an argument like
\code{current_state} ((if it's a list \code{current_state} will be unpacked) and returns its
(possibly unnormalized) log-density under the target distribution.}

\item{new_state_fn}{Function which takes a list of state parts and a
seed; returns a same-type \code{list} of \code{Tensor}s, each being a perturbation
of the input state parts. The perturbation distribution is assumed to be
a symmetric distribution centered at the input state part.
Default value: \code{NULL} which is mapped to \code{tfp$mcmc$random_walk_normal_fn()}.}

\item{seed}{integer to seed the random number generator.}

\item{name}{String name prefixed to Ops created by this function.
Default value: \code{NULL} (i.e., 'rwm_kernel').}
}
\value{
a Monte Carlo sampling kernel
}
\description{
Random Walk Metropolis is a gradient-free Markov chain Monte Carlo
(MCMC) algorithm. The algorithm involves a proposal generating step
\code{proposal_state = current_state + perturb} by a random
perturbation, followed by Metropolis-Hastings accept/reject step. For more
details see \href{http://emis.ams.org/journals/PS/images/getdoc510c.pdf?id=35&article=15&mode=pdf}{Section 2.1 of Roberts and Rosenthal (2004)}.
}
\details{
The current class implements RWM for normal and uniform proposals. Alternatively,
the user can supply any custom proposal generating function.
The function \code{one_step} can update multiple chains in parallel. It assumes
that all leftmost dimensions of \code{current_state} index independent chain states
(and are therefore updated independently). The output of
\code{target_log_prob_fn(current_state)} should sum log-probabilities across all
event dimensions. Slices along the rightmost dimensions may have different
target distributions; for example, \code{current_state[0, :]} could have a
different target distribution from \code{current_state[1, :]}. These semantics
are governed by \code{target_log_prob_fn(current_state)}. (The number of
independent chains is \code{tf$size(target_log_prob_fn(current_state))}.)
}
\seealso{
Other mcmc_kernels: \code{\link{mcmc_dual_averaging_step_size_adaptation}},
  \code{\link{mcmc_hamiltonian_monte_carlo}},
  \code{\link{mcmc_metropolis_adjusted_langevin_algorithm}},
  \code{\link{mcmc_metropolis_hastings}},
  \code{\link{mcmc_no_u_turn_sampler}},
  \code{\link{mcmc_replica_exchange_mc}},
  \code{\link{mcmc_simple_step_size_adaptation}},
  \code{\link{mcmc_slice_sampler}},
  \code{\link{mcmc_transformed_transition_kernel}},
  \code{\link{mcmc_uncalibrated_hamiltonian_monte_carlo}},
  \code{\link{mcmc_uncalibrated_langevin}},
  \code{\link{mcmc_uncalibrated_random_walk}}
}
\concept{mcmc_kernels}
