% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/glm.R
\name{glm_families}
\alias{glm_families}
\title{GLM families}
\value{
list of models that can be used as the \code{model} argument in \code{\link[=glm_fit]{glm_fit()}}
}
\description{
A list of models that can be used as the \code{model} argument in \code{\link[=glm_fit]{glm_fit()}}:
}
\details{
\itemize{
\item \code{Bernoulli}: \code{Bernoulli(probs=mean)} where \code{mean = sigmoid(matmul(X, weights))}
\item \code{BernoulliNormalCDF}: \code{Bernoulli(probs=mean)} where \code{mean = Normal(0, 1).cdf(matmul(X, weights))}
\item \code{GammaExp}: \code{Gamma(concentration=1, rate=1 / mean)} where \code{mean = exp(matmul(X, weights))}
\item \code{GammaSoftplus}: \code{Gamma(concentration=1, rate=1 / mean)} where \code{mean = softplus(matmul(X, weights))}
\item \code{LogNormal}: \code{LogNormal(loc=log(mean) - log(2) / 2, scale=sqrt(log(2)))} where
\code{mean = exp(matmul(X, weights))}.
\item \code{LogNormalSoftplus}: \code{LogNormal(loc=log(mean) - log(2) / 2, scale=sqrt(log(2)))} where
\code{mean = softplus(matmul(X, weights))}
\item \code{Normal}: \code{Normal(loc=mean, scale=1)} where \code{mean = matmul(X, weights)}.
\item \code{NormalReciprocal}: \code{Normal(loc=mean, scale=1)} where \code{mean = 1 / matmul(X, weights)}
\item \code{Poisson}: \code{Poisson(rate=mean)} where \code{mean = exp(matmul(X, weights))}.
\item \code{PoissonSoftplus}: \code{Poisson(rate=mean)} where \code{mean = softplus(matmul(X, weights))}.
}
}
\seealso{
Other glm_fit: \code{\link{glm_fit.tensorflow.tensor}},
  \code{\link{glm_fit_one_step.tensorflow.tensor}}
}
\concept{glm_fit}
