% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/distribution-layers.R
\name{layer_kl_divergence_regularizer}
\alias{layer_kl_divergence_regularizer}
\title{Regularizer that adds a KL divergence penalty to the model loss}
\usage{
layer_kl_divergence_regularizer(object, distribution_b,
  use_exact_kl = FALSE, test_points_reduce_axis = NULL,
  test_points_fn = tf$convert_to_tensor, weight = NULL, ...)
}
\arguments{
\item{object}{Model or layer object}

\item{distribution_b}{Distribution instance corresponding to b as in  \code{KL[a, b]}.
The previous layer's output is presumed to be a Distribution instance and is a.}

\item{use_exact_kl}{Logical indicating if KL divergence should be
calculated exactly via \code{tfp$distributions$kl_divergence} or via Monte Carlo approximation.
Default value: FALSE.}

\item{test_points_reduce_axis}{Integer vector or scalar representing dimensions
over which to reduce_mean while calculating the Monte Carlo approximation of the KL divergence.
As is with all tf$reduce_* ops, NULL means reduce over all dimensions;
() means reduce over none of them. Default value: () (i.e., no reduction).}

\item{test_points_fn}{A callable taking a \code{tfp$distributions$Distribution} instance and returning a tensor
used for random test points to approximate the KL divergence.
Default value: tf$convert_to_tensor.}

\item{weight}{Multiplier applied to the calculated KL divergence for each Keras batch member.
Default value: NULL (i.e., do not weight each batch member).}

\item{...}{Additional arguments passed to \code{args} of \code{keras::create_layer}.}
}
\value{
a Keras layer
}
\description{
When using Monte Carlo approximation (e.g., \code{use_exact = FALSE}), it is presumed that the input
distribution's concretization (i.e., \code{tf$convert_to_tensor(distribution)}) corresponds to a random
sample. To override this behavior, set test_points_fn.
}
\seealso{
For an example how to use in a Keras model, see \code{\link[=layer_independent_normal]{layer_independent_normal()}}.

Other distribution_layers: \code{\link{layer_categorical_mixture_of_one_hot_categorical}},
  \code{\link{layer_distribution_lambda}},
  \code{\link{layer_independent_bernoulli}},
  \code{\link{layer_independent_logistic}},
  \code{\link{layer_independent_normal}},
  \code{\link{layer_independent_poisson}},
  \code{\link{layer_kl_divergence_add_loss}},
  \code{\link{layer_mixture_logistic}},
  \code{\link{layer_mixture_normal}},
  \code{\link{layer_mixture_same_family}},
  \code{\link{layer_multivariate_normal_tri_l}},
  \code{\link{layer_one_hot_categorical}}
}
\concept{distribution_layers}
