% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sts-functions.R
\name{sts_decompose_by_component}
\alias{sts_decompose_by_component}
\title{Decompose an observed time series into contributions from each component.}
\usage{
sts_decompose_by_component(observed_time_series, model, parameter_samples)
}
\arguments{
\item{observed_time_series}{\code{float} \code{tensor} of shape
\code{concat([sample_shape, model.batch_shape, [num_timesteps, 1]])} where
\code{sample_shape} corresponds to i.i.d. observations, and the trailing \code{[1]}
dimension may (optionally) be omitted if \code{num_timesteps > 1}. May
optionally be an instance of \code{sts_masked_time_series}, which includes
a mask \code{tensor} to specify timesteps with missing observations.}

\item{model}{An instance of \code{sts_sum} representing a structural time series model.}

\item{parameter_samples}{\code{list} of \code{tensors} representing posterior samples
of model parameters, with shapes
\code{list(tf$concat(list(list(num_posterior_draws), param<1>$prior$batch_shape, param<1>$prior$event_shape), list(list(num_posterior_draws), param<2>$prior$batch_shape, param<2>$prior$event_shape), ... ) )}
for all model parameters.
This may optionally also be a named list mapping parameter names to \code{tensor} values.}
}
\value{
component_dists A named list mapping
component StructuralTimeSeries instances (elements of \code{model$components})
to \code{Distribution} instances representing the posterior marginal
distributions on the process modeled by each component. Each distribution
has batch shape matching that of \code{posterior_means}/\code{posterior_covs}, and
event shape of \code{list(num_timesteps)}.
}
\description{
This method decomposes a time series according to the posterior represention
of a structural time series model. In particular, it:
\itemize{
\item Computes the posterior marginal mean and covariances over the additive
model's latent space.
\item Decomposes the latent posterior into the marginal blocks for each
model component.
\item Maps the per-component latent posteriors back through each component's
observation model, to generate the time series modeled by that component.
}
}
\examples{
\donttest{
observed_time_series <- array(rnorm(2 * 1 * 12), dim = c(2, 1, 12))
day_of_week <- observed_time_series \%>\% sts_seasonal(num_seasons = 7, name = "seasonal")
local_linear_trend <- observed_time_series \%>\% sts_local_linear_trend(name = "local_linear")
model <- observed_time_series \%>\%
  sts_sum(components = list(day_of_week, local_linear_trend))
states_and_results <- observed_time_series \%>\%
  sts_fit_with_hmc(
    model,
    num_results = 10,
    num_warmup_steps = 5,
    num_variational_steps = 15
    )
samples <- states_and_results[[1]]

component_dists <- observed_time_series \%>\%
 sts_decompose_by_component(model = model, parameter_samples = samples)
}
}
\seealso{
Other sts-functions: \code{\link{sts_build_factored_surrogate_posterior}},
  \code{\link{sts_build_factored_variational_loss}},
  \code{\link{sts_decompose_forecast_by_component}},
  \code{\link{sts_fit_with_hmc}},
  \code{\link{sts_forecast}},
  \code{\link{sts_one_step_predictive}},
  \code{\link{sts_sample_uniform_initial_state}}
}
\concept{sts-functions}
