% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/distributions.R
\name{tfd_doublesided_maxwell}
\alias{tfd_doublesided_maxwell}
\title{Double-sided Maxwell distribution.}
\usage{
tfd_doublesided_maxwell(loc, scale, validate_args = FALSE,
  allow_nan_stats = TRUE, name = "doublesided_maxwell")
}
\arguments{
\item{loc}{Floating point tensor; location of the distribution}

\item{scale}{Floating point tensor; the scales of the distribution.
Must contain only positive values.}

\item{validate_args}{Logical, default FALSE. When TRUE distribution parameters are checked
for validity despite possibly degrading runtime performance. When FALSE invalid inputs may
silently render incorrect outputs. Default value: FALSE.}

\item{allow_nan_stats}{Logical, default TRUE. When TRUE, statistics (e.g., mean, mode, variance)
use the value NaN to indicate the result is undefined. When FALSE, an exception is raised if
one or more of the statistic's batch members are undefined.}

\item{name}{string prefixed to Ops created by this class. Default value: 'doublesided_maxwell'.}
}
\value{
a distribution instance.
}
\description{
This distribution is useful to compute measure valued derivatives for Gaussian
distributions. See Mohamed et al. (2019) for more details.
}
\details{
Mathematical details

The double-sided Maxwell distribution generalizes the Maxwell distribution to
the entire real line.\preformatted{pdf(x; mu, sigma) = 1/(sigma*sqrt(2*pi)) * ((x-mu)/sigma)^2 * exp(-0.5 ((x-mu)/sigma)^2)
}

where \code{loc = mu} and \code{scale = sigma}.
The DoublesidedMaxwell distribution is a member of the
\href{https://en.wikipedia.org/wiki/Location-scale_family}{location-scale family},
i.e., it can be constructed as,\preformatted{X ~ DoublesidedMaxwell(loc=0, scale=1)
Y = loc + scale * X
}

The double-sided Maxwell is a symmetric distribution that extends the
one-sided maxwell from R+ to the entire real line. Their densities are
therefore the same up to a factor of 0.5.

It has several methods for generating random variates from it. The version
here uses 3 Gaussian variates and a uniform variate to generate the samples
The sampling path is:

\code{mu + sigma* sgn(U-0.5)* sqrt(X^2 + Y^2 + Z^2) U~Unif; X,Y,Z ~N(0,1)}

In the sampling process above, the random variates generated by
sqrt(X^2 + Y^2 + Z^2) are samples from the one-sided Maxwell
(or Maxwell-Boltzmann) distribution.
}
\section{References}{

\itemize{
\item \href{https://arxiv.org/abs/1906.10652}{Mohamed, et all, "Monte Carlo Gradient Estimation in Machine Learning.",2019}
\item B. Heidergott, et al "Sensitivity estimation for Gaussian systems", 2008.  European Journal of Operational Research, vol. 187, pp193-207.
\item G. Pflug. "Optimization of Stochastic Models: The Interface Between Simulation and Optimization", 2002. Chp. 4.2, pg 247.
}
}

\seealso{
For usage examples see e.g. \code{\link[=tfd_sample]{tfd_sample()}}, \code{\link[=tfd_log_prob]{tfd_log_prob()}}, \code{\link[=tfd_mean]{tfd_mean()}}.
}
