% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/distributions.R
\name{tfd_plackett_luce}
\alias{tfd_plackett_luce}
\title{Plackett-Luce distribution over permutations.}
\usage{
tfd_plackett_luce(scores, dtype = tf$int32, validate_args = FALSE,
  allow_nan_stats = FALSE, name = "PlackettLuce")
}
\arguments{
\item{scores}{An N-D \code{Tensor}, \code{N >= 1}, representing the scores of a set of
elements to be permuted. The first \code{N - 1} dimensions index into a
batch of independent distributions and the last dimension represents a
vector of scores for the elements.}

\item{dtype}{The type of the event samples (default: int32).}

\item{validate_args}{Logical, default FALSE. When TRUE distribution parameters are checked
for validity despite possibly degrading runtime performance. When FALSE invalid inputs may
silently render incorrect outputs. Default value: FALSE.}

\item{allow_nan_stats}{Logical, default TRUE. When TRUE, statistics (e.g., mean, mode, variance)
use the value NaN to indicate the result is undefined. When FALSE, an exception is raised if
one or more of the statistic's batch members are undefined.}

\item{name}{name prefixed to Ops created by this class.}
}
\value{
a distribution instance.
}
\description{
The Plackett-Luce distribution is defined over permutations of
fixed length. It is parameterized by a positive score vector of same length.
This class provides methods to create indexed batches of PlackettLuce
distributions. If the provided \code{scores} is rank 2 or higher, for
every fixed set of leading dimensions, the last dimension represents one
single PlackettLuce distribution. When calling distribution
functions (e.g. \code{dist.log_prob(x)}), \code{scores} and \code{x} are broadcast to the
same shape (if possible). In all cases, the last dimension of \code{scores, x}
represents single PlackettLuce distributions.
}
\details{
Mathematical Details

The Plackett-Luce is a distribution over permutation vectors \code{p} of length \code{k}
where the permutation \code{p} is an arbitrary ordering of \code{k} indices
\code{{0, 1, ..., k-1}}.

The probability mass function (pmf) is,\preformatted{pmf(p; s) = prod_i s_{p_i} / (Z - Z_i)
Z = sum_{j=0}^{k-1} s_j
Z_i = sum_{j=0}^{i-1} s_{p_j} for i>0 and 0 for i=0
}

where \code{scores = s = [s_0, ..., s_{k-1}]}, \code{s_i >= 0}.

Samples from Plackett-Luce distribution are generated sequentially as follows.\preformatted{Initialize normalization `N_0 = Z`
For `i` in `{0, 1, ..., k-1}`
  1. Sample i-th element of permutation
     `p_i ~ Categorical(probs=[s_0/N_i, ..., s_{k-1}/N_i])`
  2. Update normalization
     `N_{i+1} = N_i-s_{p_i}`
  3. Mask out sampled index for subsequent rounds
     `s_{p_i} = 0`
Return p
}

Alternately, an equivalent way to sample from this distribution is to sort
Gumbel perturbed log-scores (Aditya et al. 2019)\preformatted{p = argsort(log s + g) ~ PlackettLuce(s)
g = [g_0, ..., g_{k-1}], g_i~ Gumbel(0, 1)
}
}
\section{References}{

\itemize{
\item Aditya Grover, Eric Wang, Aaron Zweig, Stefano Ermon. Stochastic Optimization of Sorting Networks via Continuous Relaxations. ICLR 2019.
}
}

\seealso{
For usage examples see e.g. \code{\link[=tfd_sample]{tfd_sample()}}, \code{\link[=tfd_log_prob]{tfd_log_prob()}}, \code{\link[=tfd_mean]{tfd_mean()}}.
}
