% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prep_card.R
\name{prep_big_n}
\alias{prep_big_n}
\title{Prepare \code{bigN} stat variables}
\usage{
prep_big_n(df, vars)
}
\arguments{
\item{df}{(data.frame)}

\item{vars}{(character) a vector of variables to prepare \code{bigN} for.}
}
\value{
a data.frame with the same columns as the input. The \code{stat_name}
column is modified.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

\code{prep_big_n()}:
\itemize{
\item recodes the \code{"n"} \code{stat_name} into \code{bigN} for the desired variables,
and
\item drops all other \code{stat_names} for the same variables.
}

If your \code{tfrmt} contains a \code{\link[=big_n_structure]{big_n_structure()}} you pass the tfrmt \code{column} to
\code{prep_big_n()} via \code{vars}.
}
\examples{
df <- data.frame(
  stat_name = c("n", "max", "min", rep(c("n", "N", "p"), times = 2)),
  context = rep(c("continuous", "hierarchical", "categorical"), each = 3),
  stat_variable = rep(c("a", "b", "c"), each = 3)
) |>
  dplyr::bind_rows(
    data.frame(
      stat_name = "n",
      context = "total_n",
      stat_variable = "d"
    )
  )

prep_big_n(
  df,
  vars = c("b", "c")
)
}
