% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/normalise_feature_frame.R
\name{normalise_feature_frame}
\alias{normalise_feature_frame}
\title{Scale each feature vector into a user-specified range for visualisation and modelling}
\usage{
normalise_feature_frame(
  data,
  names_var = "names",
  values_var = "values",
  method = c("z-score", "Sigmoid", "RobustSigmoid", "MinMax")
)
}
\arguments{
\item{data}{a dataframe with at least 2 columns: names variable (feature names) and value variable}

\item{names_var}{a string denoting the name of the variable/column that holds the feature names. Defaults to \code{"names"}}

\item{values_var}{a string denoting the name of the variable/column that holds the numerical feature values. Defaults to \code{"values"}}

\item{method}{a rescaling/normalising method to apply. Defaults to \code{"RobustSigmoid"}}
}
\value{
a dataframe with the value column rescaled into the specified range
}
\description{
Scale each feature vector into a user-specified range for visualisation and modelling
}
\examples{
featMat <- calculate_features(data = simData, 
  id_var = "id", 
  time_var = "timepoint", 
  values_var = "values", 
  group_var = "process", 
  feature_set = "catch22",
  seed = 123)
  
normed <- normalise_feature_frame(featMat, 
  names_var = "names", 
  values_var = "values", 
  method = "RobustSigmoid")

}
\author{
Trent Henderson
}
