% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/t4f.R
\name{t4f}
\alias{t4f}
\title{Predict taxonomic functional content via tax4fun}
\usage{
t4f(
  otu_table,
  rows_are_taxa,
  tax_table,
  reference_path,
  type = c("uproc", "pauda"),
  short = TRUE,
  cn_normalize = FALSE,
  sample_normalize = FALSE,
  scalar,
  drop = TRUE,
  verbose = FALSE
)
}
\arguments{
\item{otu_table}{(required) Matrix or dataframe containing taxa abundances
(counts, non-negative integers) across samples. Rows and columns must be
uniquely named.}

\item{rows_are_taxa}{(required) Logical flag indicating whether otu_table
rows correspond to taxa (TRUE) or samples (FALSE).}

\item{tax_table}{Matrix or dataframe containing Silva taxonimic information
with row or column names corresponding to the otu_table. Silva species
information is required.}

\item{reference_path}{Folder path of the silva-to-kegg mapping file
(t4f_silva_to_kegg.rds) and reference profiles (t4f_ref_profiles.rds). Must
not be renamed.}

\item{type}{Type of protein domain classification methods used to generate
references (uproc or pauda). Defaults to uproc.}

\item{short}{Logical flag whether to use a short or long read
references. Defaults to TRUE.}

\item{cn_normalize}{Logical flag for performing 16S rRNA copy number
normalization. Defaults to FALSE.}

\item{sample_normalize}{Logical flag to normalize functional
predictions by the total functional abundance in a sample. Defaults to FALSE.}

\item{scalar}{Value for scaling the topics over functions distrubution
to predicted counts.}

\item{drop}{Logical flag to drop empty gene columns after prediction. Defaults to TRUE.}

\item{verbose}{Logical flag to print progress information. Defaults to FALSE.}
}
\value{
A list containing
\describe{
\item{fxn_table}{A matrix of gene counts across topics.}
\item{fxn_meta}{A list of functional metadata corresponding to fxn_table.}
\item{method_meta}{A matrix of method specific metadata (FTU).}
}
}
\description{
Given a taxonomic abundance table prepared with the Silva reference database,
predicts the functional content using a KO precalculated mapping
table that maps the taxonomic abundance for a given tax_table to functional
abundance content across a set of functional genes.
}
\examples{
\dontrun{
download_ref(destination='/references',reference='silva_ko')
predicted_functions <- t4f(otu_table=DAVID$OTU,rows_are_taxa=FALSE,
                           tax_table=DAVID$TAX,reference='/references',
                           type='uproc',short=TRUE,cn_normalize=TRUE,
                           sample_normalize=FALSE,scalar=NULL,drop=TRUE)
                           }

}
\references{
ABhauer, K. P., Wemheuer, B. Daniel, R., and Meinicke, P. (2015).
Bioinformatics, 1-3. 31(17).
}
\seealso{
\code{\link{download_ref}} \code{\link{picrust}}
}
