% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scatterplot.R
\name{lines3d}
\alias{lines3d}
\title{Add lines to a 3D scatterplot}
\usage{
lines3d(s, from, to, lwd = 1, alpha = 1, color)
}
\arguments{
\item{s}{A scatterplot object returned by \code{\link{scatterplot3js}}.}

\item{from}{A vector of integer indices of starting points.}

\item{to}{A vector of integer indices of ending points of the same length as \code{from}.}

\item{lwd}{A single numeric value of line width (applies to all lines).}

\item{alpha}{A single numeric value of line alpha (applies to all lines).}

\item{color}{Either a single color value or vector of values as long as \code{from} of line colors;
line colors default to interpolating their vertex point colors.}
}
\value{
A new scatterplot htmlwidget object.
}
\description{
Add lines to a 3D scatterplot
}
\note{
This function replaces the old \code{points3d} approach used by \code{scatterplot3d}.
}
\examples{
\dontrun{
 x <- rnorm(5)
 y <- rnorm(5)
 z <- rnorm(5)
 scatterplot3js(x, y, z, pch="@", color=rainbow(5)) \%>\%
   lines3d(c(1, 2), c(3, 4), lwd=2)
}
}

