% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sounding_hodograph.R
\name{sounding_hodograph}
\alias{sounding_hodograph}
\title{Plot hodograph based on rawinsonde data}
\usage{
sounding_hodograph(
  ws,
  wd,
  altitude,
  max_hght = 12000,
  max_speed = 25,
  lab_hghts = c(0, 1, 3, 6, 9, 12),
  close_par = TRUE,
  SRH_polygon = "03km_RM",
  storm_motion = c(999, 999),
  ...
)
}
\arguments{
\item{ws}{wind speed [knots]}

\item{wd}{wind direction [azimuth in degrees]}

\item{altitude}{altitude [m] (can be above sea level or above ground level as function always consider first level as surface, i.e h = 0 m) altitude [m]}

\item{max_hght}{maximum altitude [km] to be considered on the hodograph, 12 km used by default}

\item{max_speed}{displayed range of the drawn hodograph [m/s], 25 m/s used as default}

\item{lab_hghts}{height labels [km] to be drawn on the hodograph, 0, 1, 3, 6, 9, 12 used by default; NULL for skipping labels}

\item{close_par}{if plot will be modified in next steps storing par settings is needed. This logical argument is turned on by default. If you want to modify Skew-T plot in next step set it to FALSE}

\item{SRH_polygon}{draws polygon for storm-relative helicity, available options are "0500m", "01km", "03km", "36km", "none", "03km" used as default}

\item{storm_motion}{(optional) for moving storms only - one can define 
wind speed [m/s] and wind directions [degrees] that will be used to compute adjusted SRH parameters}

\item{...}{other graphical parameters to be used with plot() function}
}
\value{
hodograph plot
}
\description{
Plot hodograph to show changes in wind speed and wind direction with height
}
\examples{
#northplatte = get_sounding(wmo_id = 72562, yy = 1999, mm = 7, dd = 3, hh = 0)
data("northplatte") 
sounding_hodograph(
  ws = northplatte$ws, wd = northplatte$wd,
  altitude = northplatte$altitude, max_speed = 40
)
title("North Platte - 3 July 1999, 00:00 UTC")
}
