// Generated by rstantools.  Do not edit by hand.

/*
    thurstonianIRT is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    thurstonianIRT is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with thurstonianIRT.  If not, see <http://www.gnu.org/licenses/>.
*/
#ifndef MODELS_HPP
#define MODELS_HPP
#define STAN__SERVICES__COMMAND_HPP
#ifndef USE_STANC3
#define USE_STANC3
#endif
#include <rstan/rstaninc.hpp>
// Code generated by stanc v2.26.1-4-gd72b68b7-dirty
#include <stan/model/model_header.hpp>
namespace model_thurstonian_irt_model_namespace {
inline void validate_positive_index(const char* var_name, const char* expr,
                                    int val) {
  if (val < 1) {
    std::stringstream msg;
    msg << "Found dimension size less than one in simplex declaration"
        << "; variable=" << var_name << "; dimension size expression=" << expr
        << "; expression value=" << val;
    std::string msg_str(msg.str());
    throw std::invalid_argument(msg_str.c_str());
  }
}
inline void validate_unit_vector_index(const char* var_name, const char* expr,
                                       int val) {
  if (val <= 1) {
    std::stringstream msg;
    if (val == 1) {
      msg << "Found dimension size one in unit vector declaration."
          << " One-dimensional unit vector is discrete"
          << " but the target distribution must be continuous."
          << " variable=" << var_name << "; dimension size expression=" << expr;
    } else {
      msg << "Found dimension size less than one in unit vector declaration"
          << "; variable=" << var_name << "; dimension size expression=" << expr
          << "; expression value=" << val;
    }
    std::string msg_str(msg.str());
    throw std::invalid_argument(msg_str.c_str());
  }
}
using std::istream;
using std::string;
using std::stringstream;
using std::vector;
using std::pow;
using stan::io::dump;
using stan::math::lgamma;
using stan::model::model_base_crtp;
using stan::model::rvalue;
using stan::model::cons_list;
using stan::model::index_uni;
using stan::model::index_max;
using stan::model::index_min;
using stan::model::index_min_max;
using stan::model::index_multi;
using stan::model::index_omni;
using stan::model::nil_index_list;
using namespace stan::math;
using stan::math::pow; 
stan::math::profile_map profiles__;
static int current_statement__= 0;
static const std::vector<string> locations_array__ = {" (found before start of program)",
                                                      " (in 'thurstonian_irt_model', line 71, column 2 to column 72)",
                                                      " (in 'thurstonian_irt_model', line 72, column 2 to column 63)",
                                                      " (in 'thurstonian_irt_model', line 73, column 2 to column 41)",
                                                      " (in 'thurstonian_irt_model', line 74, column 2 to column 41)",
                                                      " (in 'thurstonian_irt_model', line 75, column 2 to column 38)",
                                                      " (in 'thurstonian_irt_model', line 77, column 2 to column 36)",
                                                      " (in 'thurstonian_irt_model', line 79, column 2 to column 40)",
                                                      " (in 'thurstonian_irt_model', line 80, column 2 to column 19)",
                                                      " (in 'thurstonian_irt_model', line 83, column 2 to column 44)",
                                                      " (in 'thurstonian_irt_model', line 87, column 2 to column 32)",
                                                      " (in 'thurstonian_irt_model', line 88, column 2 to column 24)",
                                                      " (in 'thurstonian_irt_model', line 89, column 2 to column 30)",
                                                      " (in 'thurstonian_irt_model', line 90, column 2 to column 19)",
                                                      " (in 'thurstonian_irt_model', line 91, column 2 to column 29)",
                                                      " (in 'thurstonian_irt_model', line 92, column 2 to column 28)",
                                                      " (in 'thurstonian_irt_model', line 93, column 2 to column 28)",
                                                      " (in 'thurstonian_irt_model', line 94, column 2 to column 39)",
                                                      " (in 'thurstonian_irt_model', line 95, column 2 to column 34)",
                                                      " (in 'thurstonian_irt_model', line 96, column 2 to column 34)",
                                                      " (in 'thurstonian_irt_model', line 97, column 2 to column 45)",
                                                      " (in 'thurstonian_irt_model', line 99, column 2 to column 15)",
                                                      " (in 'thurstonian_irt_model', line 161, column 2 to column 33)",
                                                      " (in 'thurstonian_irt_model', line 162, column 2 to column 57)",
                                                      " (in 'thurstonian_irt_model', line 103, column 9 to column 10)",
                                                      " (in 'thurstonian_irt_model', line 103, column 2 to column 15)",
                                                      " (in 'thurstonian_irt_model', line 104, column 9 to column 10)",
                                                      " (in 'thurstonian_irt_model', line 104, column 2 to column 20)",
                                                      " (in 'thurstonian_irt_model', line 107, column 4 to line 109, column 57)",
                                                      " (in 'thurstonian_irt_model', line 111, column 4 to column 61)",
                                                      " (in 'thurstonian_irt_model', line 105, column 17 to line 112, column 3)",
                                                      " (in 'thurstonian_irt_model', line 105, column 2 to line 112, column 3)",
                                                      " (in 'thurstonian_irt_model', line 140, column 6 to column 60)",
                                                      " (in 'thurstonian_irt_model', line 139, column 19 to line 141, column 5)",
                                                      " (in 'thurstonian_irt_model', line 139, column 4 to line 141, column 5)",
                                                      " (in 'thurstonian_irt_model', line 142, column 4 to column 51)",
                                                      " (in 'thurstonian_irt_model', line 137, column 26 to line 143, column 3)",
                                                      " (in 'thurstonian_irt_model', line 137, column 9 to line 143, column 3)",
                                                      " (in 'thurstonian_irt_model', line 133, column 6 to column 40)",
                                                      " (in 'thurstonian_irt_model', line 132, column 19 to line 134, column 5)",
                                                      " (in 'thurstonian_irt_model', line 132, column 4 to line 134, column 5)",
                                                      " (in 'thurstonian_irt_model', line 136, column 4 to column 26)",
                                                      " (in 'thurstonian_irt_model', line 130, column 26 to line 137, column 3)",
                                                      " (in 'thurstonian_irt_model', line 130, column 9 to line 143, column 3)",
                                                      " (in 'thurstonian_irt_model', line 125, column 13 to column 21)",
                                                      " (in 'thurstonian_irt_model', line 125, column 6 to column 66)",
                                                      " (in 'thurstonian_irt_model', line 126, column 6 to column 26)",
                                                      " (in 'thurstonian_irt_model', line 128, column 6 to column 45)",
                                                      " (in 'thurstonian_irt_model', line 123, column 19 to line 129, column 5)",
                                                      " (in 'thurstonian_irt_model', line 123, column 4 to line 129, column 5)",
                                                      " (in 'thurstonian_irt_model', line 121, column 26 to line 130, column 3)",
                                                      " (in 'thurstonian_irt_model', line 121, column 9 to line 143, column 3)",
                                                      " (in 'thurstonian_irt_model', line 118, column 6 to column 60)",
                                                      " (in 'thurstonian_irt_model', line 116, column 19 to line 119, column 5)",
                                                      " (in 'thurstonian_irt_model', line 116, column 4 to line 119, column 5)",
                                                      " (in 'thurstonian_irt_model', line 120, column 4 to column 25)",
                                                      " (in 'thurstonian_irt_model', line 114, column 19 to line 121, column 3)",
                                                      " (in 'thurstonian_irt_model', line 114, column 2 to line 143, column 3)",
                                                      " (in 'thurstonian_irt_model', line 150, column 4 to column 25)",
                                                      " (in 'thurstonian_irt_model', line 149, column 9 to line 151, column 3)",
                                                      " (in 'thurstonian_irt_model', line 147, column 6 to column 34)",
                                                      " (in 'thurstonian_irt_model', line 146, column 25 to line 148, column 5)",
                                                      " (in 'thurstonian_irt_model', line 146, column 4 to line 148, column 5)",
                                                      " (in 'thurstonian_irt_model', line 145, column 19 to line 149, column 3)",
                                                      " (in 'thurstonian_irt_model', line 145, column 2 to line 151, column 3)",
                                                      " (in 'thurstonian_irt_model', line 152, column 2 to column 30)",
                                                      " (in 'thurstonian_irt_model', line 153, column 2 to column 31)",
                                                      " (in 'thurstonian_irt_model', line 154, column 2 to column 27)",
                                                      " (in 'thurstonian_irt_model', line 155, column 2 to column 33)",
                                                      " (in 'thurstonian_irt_model', line 156, column 2 to column 36)",
                                                      " (in 'thurstonian_irt_model', line 157, column 2 to column 19)",
                                                      " (in 'thurstonian_irt_model', line 28, column 2 to column 30)",
                                                      " (in 'thurstonian_irt_model', line 33, column 2 to column 17)",
                                                      " (in 'thurstonian_irt_model', line 35, column 8 to column 42)",
                                                      " (in 'thurstonian_irt_model', line 35, column 2 to column 53)",
                                                      " (in 'thurstonian_irt_model', line 36, column 8 to column 42)",
                                                      " (in 'thurstonian_irt_model', line 36, column 2 to column 55)",
                                                      " (in 'thurstonian_irt_model', line 37, column 2 to column 22)",
                                                      " (in 'thurstonian_irt_model', line 38, column 2 to column 23)",
                                                      " (in 'thurstonian_irt_model', line 39, column 2 to column 24)",
                                                      " (in 'thurstonian_irt_model', line 40, column 2 to column 23)",
                                                      " (in 'thurstonian_irt_model', line 41, column 2 to column 26)",
                                                      " (in 'thurstonian_irt_model', line 42, column 2 to column 26)",
                                                      " (in 'thurstonian_irt_model', line 44, column 8 to column 9)",
                                                      " (in 'thurstonian_irt_model', line 44, column 2 to column 32)",
                                                      " (in 'thurstonian_irt_model', line 45, column 8 to column 9)",
                                                      " (in 'thurstonian_irt_model', line 45, column 2 to column 32)",
                                                      " (in 'thurstonian_irt_model', line 46, column 8 to column 9)",
                                                      " (in 'thurstonian_irt_model', line 46, column 2 to column 32)",
                                                      " (in 'thurstonian_irt_model', line 47, column 8 to column 9)",
                                                      " (in 'thurstonian_irt_model', line 47, column 2 to column 33)",
                                                      " (in 'thurstonian_irt_model', line 48, column 8 to column 9)",
                                                      " (in 'thurstonian_irt_model', line 48, column 2 to column 33)",
                                                      " (in 'thurstonian_irt_model', line 49, column 8 to column 9)",
                                                      " (in 'thurstonian_irt_model', line 49, column 2 to column 33)",
                                                      " (in 'thurstonian_irt_model', line 50, column 8 to column 18)",
                                                      " (in 'thurstonian_irt_model', line 50, column 2 to column 44)",
                                                      " (in 'thurstonian_irt_model', line 51, column 8 to column 18)",
                                                      " (in 'thurstonian_irt_model', line 51, column 2 to column 44)",
                                                      " (in 'thurstonian_irt_model', line 53, column 2 to column 26)",
                                                      " (in 'thurstonian_irt_model', line 54, column 2 to column 26)",
                                                      " (in 'thurstonian_irt_model', line 55, column 8 to column 18)",
                                                      " (in 'thurstonian_irt_model', line 55, column 2 to column 44)",
                                                      " (in 'thurstonian_irt_model', line 56, column 8 to column 18)",
                                                      " (in 'thurstonian_irt_model', line 56, column 2 to column 44)",
                                                      " (in 'thurstonian_irt_model', line 58, column 2 to column 28)",
                                                      " (in 'thurstonian_irt_model', line 59, column 8 to column 20)",
                                                      " (in 'thurstonian_irt_model', line 59, column 2 to column 48)",
                                                      " (in 'thurstonian_irt_model', line 60, column 8 to column 20)",
                                                      " (in 'thurstonian_irt_model', line 60, column 2 to column 47)",
                                                      " (in 'thurstonian_irt_model', line 63, column 2 to column 20)",
                                                      " (in 'thurstonian_irt_model', line 66, column 18 to column 28)",
                                                      " (in 'thurstonian_irt_model', line 66, column 2 to column 38)",
                                                      " (in 'thurstonian_irt_model', line 67, column 2 to column 40)",
                                                      " (in 'thurstonian_irt_model', line 71, column 9 to column 64)",
                                                      " (in 'thurstonian_irt_model', line 72, column 8 to column 33)",
                                                      " (in 'thurstonian_irt_model', line 72, column 43 to column 51)",
                                                      " (in 'thurstonian_irt_model', line 73, column 18 to column 28)",
                                                      " (in 'thurstonian_irt_model', line 74, column 18 to column 28)",
                                                      " (in 'thurstonian_irt_model', line 75, column 18 to column 28)",
                                                      " (in 'thurstonian_irt_model', line 77, column 9 to column 16)",
                                                      " (in 'thurstonian_irt_model', line 77, column 18 to column 26)",
                                                      " (in 'thurstonian_irt_model', line 79, column 23 to column 30)",
                                                      " (in 'thurstonian_irt_model', line 80, column 9 to column 15)",
                                                      " (in 'thurstonian_irt_model', line 83, column 18 to column 37)",
                                                      " (in 'thurstonian_irt_model', line 87, column 9 to column 17)",
                                                      " (in 'thurstonian_irt_model', line 87, column 19 to column 26)",
                                                      " (in 'thurstonian_irt_model', line 88, column 9 to column 15)",
                                                      " (in 'thurstonian_irt_model', line 89, column 18 to column 24)",
                                                      " (in 'thurstonian_irt_model', line 90, column 9 to column 15)",
                                                      " (in 'thurstonian_irt_model', line 161, column 14 to column 21)",
                                                      " (in 'thurstonian_irt_model', line 13, column 5 to column 40)",
                                                      " (in 'thurstonian_irt_model', line 14, column 5 to column 12)",
                                                      " (in 'thurstonian_irt_model', line 20, column 7 to column 55)",
                                                      " (in 'thurstonian_irt_model', line 19, column 12 to line 21, column 6)",
                                                      " (in 'thurstonian_irt_model', line 18, column 7 to column 41)",
                                                      " (in 'thurstonian_irt_model', line 17, column 31 to line 19, column 6)",
                                                      " (in 'thurstonian_irt_model', line 17, column 12 to line 21, column 6)",
                                                      " (in 'thurstonian_irt_model', line 16, column 7 to column 30)",
                                                      " (in 'thurstonian_irt_model', line 15, column 17 to line 17, column 6)",
                                                      " (in 'thurstonian_irt_model', line 15, column 5 to line 21, column 6)",
                                                      " (in 'thurstonian_irt_model', line 22, column 5 to column 19)",
                                                      " (in 'thurstonian_irt_model', line 12, column 58 to line 23, column 4)"};
template <bool propto__, typename T1__, typename T2__>
stan::promote_args_t<T1__,
stan::value_type_t<T2__>>
cumulative_Phi_lpmf(const int& y, const T1__& mu, const T2__& thres_arg__,
                    std::ostream* pstream__) {
  using local_scalar_t__ = stan::promote_args_t<T1__,
          stan::value_type_t<T2__>>;
  const auto& thres = to_ref(thres_arg__);
  local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
  (void) DUMMY_VAR__;  // suppress unused var warning
  
  try {
    int ncat;
    ncat = std::numeric_limits<int>::min();
    
    current_statement__ = 131;
    ncat = (num_elements(thres) + 1);
    local_scalar_t__ p;
    p = DUMMY_VAR__;
    
    current_statement__ = 140;
    if (logical_eq(y, 0)) {
      current_statement__ = 138;
      p = Phi((thres[(1 - 1)] - mu));
    } else {
      current_statement__ = 137;
      if (logical_eq(y, (ncat - 1))) {
        current_statement__ = 135;
        p = (1 - Phi((thres[((ncat - 1) - 1)] - mu)));
      } else {
        current_statement__ = 133;
        p = (Phi((thres[((y + 1) - 1)] - mu)) - Phi((thres[(y - 1)] - mu)));
      }
    }
    current_statement__ = 141;
    return stan::math::log(p);
  } catch (const std::exception& e) {
    stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
  }
  
}
struct cumulative_Phi_lpmf_functor__ {
template <bool propto__, typename T1__, typename T2__>
stan::promote_args_t<T1__,
stan::value_type_t<T2__>>
operator()(const int& y, const T1__& mu, const T2__& thres,
           std::ostream* pstream__)  const 
{
return cumulative_Phi_lpmf<propto__>(y, mu, thres, pstream__);
}
};
#include <stan_meta_header.hpp>
class model_thurstonian_irt_model final : public model_base_crtp<model_thurstonian_irt_model> {
private:
  int family;
  int N;
  std::vector<int> Yint;
  std::vector<double> Yreal;
  int N_item;
  int N_itemC;
  int N_person;
  int N_trait;
  int N_item_fix;
  int N_item_est;
  std::vector<int> J_item1;
  std::vector<int> J_item2;
  std::vector<int> J_itemC;
  std::vector<int> J_person;
  std::vector<int> J_trait1;
  std::vector<int> J_trait2;
  std::vector<int> J_item_fix;
  std::vector<int> J_item_est;
  int N_item_pos;
  int N_item_neg;
  std::vector<int> J_item_pos;
  std::vector<int> J_item_neg;
  int N_item_equal;
  std::vector<int> J_item_equal;
  std::vector<int> J_item_orig;
  int ncat;
  Eigen::Matrix<double, -1, 1> psi_fix;
  int gamma_1dim__;
  int gamma_ord_1dim__;
  int gamma_ord_2dim__;
  int disp_1dim__;
 
public:
  ~model_thurstonian_irt_model() { }
  
  inline std::string model_name() const final { return "model_thurstonian_irt_model"; }
  inline std::vector<std::string> model_compile_info() const noexcept {
    return std::vector<std::string>{"stanc_version = stanc3 v2.26.1-4-gd72b68b7-dirty", "stancflags = "};
  }
  
  
  model_thurstonian_irt_model(stan::io::var_context& context__,
                              unsigned int random_seed__ = 0,
                              std::ostream* pstream__ = nullptr) : model_base_crtp(0) {
    using local_scalar_t__ = double ;
    boost::ecuyer1988 base_rng__ = 
        stan::services::util::create_rng(random_seed__, 0);
    (void) base_rng__;  // suppress unused var warning
    static const char* function__ = "model_thurstonian_irt_model_namespace::model_thurstonian_irt_model";
    (void) function__;  // suppress unused var warning
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    (void) DUMMY_VAR__;  // suppress unused var warning
    
    try {
      int pos__;
      pos__ = std::numeric_limits<int>::min();
      
      pos__ = 1;
      current_statement__ = 71;
      context__.validate_dims("data initialization","family","int",
          context__.to_vec());
      family = std::numeric_limits<int>::min();
      
      current_statement__ = 71;
      family = context__.vals_i("family")[(1 - 1)];
      current_statement__ = 71;
      current_statement__ = 71;
      check_greater_or_equal(function__, "family", family, 1);
      current_statement__ = 71;
      current_statement__ = 71;
      check_less_or_equal(function__, "family", family, 4);
      current_statement__ = 72;
      context__.validate_dims("data initialization","N","int",
          context__.to_vec());
      N = std::numeric_limits<int>::min();
      
      current_statement__ = 72;
      N = context__.vals_i("N")[(1 - 1)];
      current_statement__ = 72;
      current_statement__ = 72;
      check_greater_or_equal(function__, "N", N, 1);
      current_statement__ = 73;
      validate_non_negative_index("Yint",
                                  "family == 1 || family == 2 ? N : 0",
                                  ((primitive_value(logical_eq(family, 1)) ||
                                     primitive_value(logical_eq(family, 2)))
                                     ? N : 0));
      current_statement__ = 74;
      context__.validate_dims("data initialization","Yint","int",
          context__.to_vec(
            ((primitive_value(logical_eq(family, 1)) || primitive_value(
               logical_eq(family, 2))) ? N : 0)));
      Yint = std::vector<int>(((primitive_value(logical_eq(family, 1)) ||
                                 primitive_value(logical_eq(family, 2))) ? N
                                 : 0), std::numeric_limits<int>::min());
      
      current_statement__ = 74;
      assign(Yint, nil_index_list(), context__.vals_i("Yint"),
        "assigning variable Yint");
      current_statement__ = 75;
      validate_non_negative_index("Yreal",
                                  "family == 3 || family == 4 ? N : 0",
                                  ((primitive_value(logical_eq(family, 3)) ||
                                     primitive_value(logical_eq(family, 4)))
                                     ? N : 0));
      current_statement__ = 76;
      context__.validate_dims("data initialization","Yreal","double",
          context__.to_vec(
            ((primitive_value(logical_eq(family, 3)) || primitive_value(
               logical_eq(family, 4))) ? N : 0)));
      Yreal = std::vector<double>(((primitive_value(logical_eq(family, 3)) ||
                                     primitive_value(logical_eq(family, 4)))
                                     ? N : 0), std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 76;
      assign(Yreal, nil_index_list(), context__.vals_r("Yreal"),
        "assigning variable Yreal");
      current_statement__ = 77;
      context__.validate_dims("data initialization","N_item","int",
          context__.to_vec());
      N_item = std::numeric_limits<int>::min();
      
      current_statement__ = 77;
      N_item = context__.vals_i("N_item")[(1 - 1)];
      current_statement__ = 77;
      current_statement__ = 77;
      check_greater_or_equal(function__, "N_item", N_item, 1);
      current_statement__ = 78;
      context__.validate_dims("data initialization","N_itemC","int",
          context__.to_vec());
      N_itemC = std::numeric_limits<int>::min();
      
      current_statement__ = 78;
      N_itemC = context__.vals_i("N_itemC")[(1 - 1)];
      current_statement__ = 78;
      current_statement__ = 78;
      check_greater_or_equal(function__, "N_itemC", N_itemC, 1);
      current_statement__ = 79;
      context__.validate_dims("data initialization","N_person","int",
          context__.to_vec());
      N_person = std::numeric_limits<int>::min();
      
      current_statement__ = 79;
      N_person = context__.vals_i("N_person")[(1 - 1)];
      current_statement__ = 79;
      current_statement__ = 79;
      check_greater_or_equal(function__, "N_person", N_person, 1);
      current_statement__ = 80;
      context__.validate_dims("data initialization","N_trait","int",
          context__.to_vec());
      N_trait = std::numeric_limits<int>::min();
      
      current_statement__ = 80;
      N_trait = context__.vals_i("N_trait")[(1 - 1)];
      current_statement__ = 80;
      current_statement__ = 80;
      check_greater_or_equal(function__, "N_trait", N_trait, 1);
      current_statement__ = 81;
      context__.validate_dims("data initialization","N_item_fix","int",
          context__.to_vec());
      N_item_fix = std::numeric_limits<int>::min();
      
      current_statement__ = 81;
      N_item_fix = context__.vals_i("N_item_fix")[(1 - 1)];
      current_statement__ = 81;
      current_statement__ = 81;
      check_greater_or_equal(function__, "N_item_fix", N_item_fix, 0);
      current_statement__ = 82;
      context__.validate_dims("data initialization","N_item_est","int",
          context__.to_vec());
      N_item_est = std::numeric_limits<int>::min();
      
      current_statement__ = 82;
      N_item_est = context__.vals_i("N_item_est")[(1 - 1)];
      current_statement__ = 82;
      current_statement__ = 82;
      check_greater_or_equal(function__, "N_item_est", N_item_est, 0);
      current_statement__ = 83;
      validate_non_negative_index("J_item1", "N", N);
      current_statement__ = 84;
      context__.validate_dims("data initialization","J_item1","int",
          context__.to_vec(N));
      J_item1 = std::vector<int>(N, std::numeric_limits<int>::min());
      
      current_statement__ = 84;
      assign(J_item1, nil_index_list(), context__.vals_i("J_item1"),
        "assigning variable J_item1");
      current_statement__ = 84;
      for (int sym1__ = 1; sym1__ <= N; ++sym1__) {
        current_statement__ = 84;
        current_statement__ = 84;
        check_greater_or_equal(function__, "J_item1[sym1__]",
                               J_item1[(sym1__ - 1)], 1);}
      current_statement__ = 85;
      validate_non_negative_index("J_item2", "N", N);
      current_statement__ = 86;
      context__.validate_dims("data initialization","J_item2","int",
          context__.to_vec(N));
      J_item2 = std::vector<int>(N, std::numeric_limits<int>::min());
      
      current_statement__ = 86;
      assign(J_item2, nil_index_list(), context__.vals_i("J_item2"),
        "assigning variable J_item2");
      current_statement__ = 86;
      for (int sym1__ = 1; sym1__ <= N; ++sym1__) {
        current_statement__ = 86;
        current_statement__ = 86;
        check_greater_or_equal(function__, "J_item2[sym1__]",
                               J_item2[(sym1__ - 1)], 1);}
      current_statement__ = 87;
      validate_non_negative_index("J_itemC", "N", N);
      current_statement__ = 88;
      context__.validate_dims("data initialization","J_itemC","int",
          context__.to_vec(N));
      J_itemC = std::vector<int>(N, std::numeric_limits<int>::min());
      
      current_statement__ = 88;
      assign(J_itemC, nil_index_list(), context__.vals_i("J_itemC"),
        "assigning variable J_itemC");
      current_statement__ = 88;
      for (int sym1__ = 1; sym1__ <= N; ++sym1__) {
        current_statement__ = 88;
        current_statement__ = 88;
        check_greater_or_equal(function__, "J_itemC[sym1__]",
                               J_itemC[(sym1__ - 1)], 1);}
      current_statement__ = 89;
      validate_non_negative_index("J_person", "N", N);
      current_statement__ = 90;
      context__.validate_dims("data initialization","J_person","int",
          context__.to_vec(N));
      J_person = std::vector<int>(N, std::numeric_limits<int>::min());
      
      current_statement__ = 90;
      assign(J_person, nil_index_list(), context__.vals_i("J_person"),
        "assigning variable J_person");
      current_statement__ = 90;
      for (int sym1__ = 1; sym1__ <= N; ++sym1__) {
        current_statement__ = 90;
        current_statement__ = 90;
        check_greater_or_equal(function__, "J_person[sym1__]",
                               J_person[(sym1__ - 1)], 1);}
      current_statement__ = 91;
      validate_non_negative_index("J_trait1", "N", N);
      current_statement__ = 92;
      context__.validate_dims("data initialization","J_trait1","int",
          context__.to_vec(N));
      J_trait1 = std::vector<int>(N, std::numeric_limits<int>::min());
      
      current_statement__ = 92;
      assign(J_trait1, nil_index_list(), context__.vals_i("J_trait1"),
        "assigning variable J_trait1");
      current_statement__ = 92;
      for (int sym1__ = 1; sym1__ <= N; ++sym1__) {
        current_statement__ = 92;
        current_statement__ = 92;
        check_greater_or_equal(function__, "J_trait1[sym1__]",
                               J_trait1[(sym1__ - 1)], 1);}
      current_statement__ = 93;
      validate_non_negative_index("J_trait2", "N", N);
      current_statement__ = 94;
      context__.validate_dims("data initialization","J_trait2","int",
          context__.to_vec(N));
      J_trait2 = std::vector<int>(N, std::numeric_limits<int>::min());
      
      current_statement__ = 94;
      assign(J_trait2, nil_index_list(), context__.vals_i("J_trait2"),
        "assigning variable J_trait2");
      current_statement__ = 94;
      for (int sym1__ = 1; sym1__ <= N; ++sym1__) {
        current_statement__ = 94;
        current_statement__ = 94;
        check_greater_or_equal(function__, "J_trait2[sym1__]",
                               J_trait2[(sym1__ - 1)], 1);}
      current_statement__ = 95;
      validate_non_negative_index("J_item_fix", "N_item_fix", N_item_fix);
      current_statement__ = 96;
      context__.validate_dims("data initialization","J_item_fix","int",
          context__.to_vec(N_item_fix));
      J_item_fix = std::vector<int>(N_item_fix, std::numeric_limits<int>::min());
      
      current_statement__ = 96;
      assign(J_item_fix, nil_index_list(), context__.vals_i("J_item_fix"),
        "assigning variable J_item_fix");
      current_statement__ = 96;
      for (int sym1__ = 1; sym1__ <= N_item_fix; ++sym1__) {
        current_statement__ = 96;
        current_statement__ = 96;
        check_greater_or_equal(function__, "J_item_fix[sym1__]",
                               J_item_fix[(sym1__ - 1)], 1);}
      current_statement__ = 97;
      validate_non_negative_index("J_item_est", "N_item_est", N_item_est);
      current_statement__ = 98;
      context__.validate_dims("data initialization","J_item_est","int",
          context__.to_vec(N_item_est));
      J_item_est = std::vector<int>(N_item_est, std::numeric_limits<int>::min());
      
      current_statement__ = 98;
      assign(J_item_est, nil_index_list(), context__.vals_i("J_item_est"),
        "assigning variable J_item_est");
      current_statement__ = 98;
      for (int sym1__ = 1; sym1__ <= N_item_est; ++sym1__) {
        current_statement__ = 98;
        current_statement__ = 98;
        check_greater_or_equal(function__, "J_item_est[sym1__]",
                               J_item_est[(sym1__ - 1)], 1);}
      current_statement__ = 99;
      context__.validate_dims("data initialization","N_item_pos","int",
          context__.to_vec());
      N_item_pos = std::numeric_limits<int>::min();
      
      current_statement__ = 99;
      N_item_pos = context__.vals_i("N_item_pos")[(1 - 1)];
      current_statement__ = 99;
      current_statement__ = 99;
      check_greater_or_equal(function__, "N_item_pos", N_item_pos, 0);
      current_statement__ = 100;
      context__.validate_dims("data initialization","N_item_neg","int",
          context__.to_vec());
      N_item_neg = std::numeric_limits<int>::min();
      
      current_statement__ = 100;
      N_item_neg = context__.vals_i("N_item_neg")[(1 - 1)];
      current_statement__ = 100;
      current_statement__ = 100;
      check_greater_or_equal(function__, "N_item_neg", N_item_neg, 0);
      current_statement__ = 101;
      validate_non_negative_index("J_item_pos", "N_item_pos", N_item_pos);
      current_statement__ = 102;
      context__.validate_dims("data initialization","J_item_pos","int",
          context__.to_vec(N_item_pos));
      J_item_pos = std::vector<int>(N_item_pos, std::numeric_limits<int>::min());
      
      current_statement__ = 102;
      assign(J_item_pos, nil_index_list(), context__.vals_i("J_item_pos"),
        "assigning variable J_item_pos");
      current_statement__ = 102;
      for (int sym1__ = 1; sym1__ <= N_item_pos; ++sym1__) {
        current_statement__ = 102;
        current_statement__ = 102;
        check_greater_or_equal(function__, "J_item_pos[sym1__]",
                               J_item_pos[(sym1__ - 1)], 1);}
      current_statement__ = 103;
      validate_non_negative_index("J_item_neg", "N_item_neg", N_item_neg);
      current_statement__ = 104;
      context__.validate_dims("data initialization","J_item_neg","int",
          context__.to_vec(N_item_neg));
      J_item_neg = std::vector<int>(N_item_neg, std::numeric_limits<int>::min());
      
      current_statement__ = 104;
      assign(J_item_neg, nil_index_list(), context__.vals_i("J_item_neg"),
        "assigning variable J_item_neg");
      current_statement__ = 104;
      for (int sym1__ = 1; sym1__ <= N_item_neg; ++sym1__) {
        current_statement__ = 104;
        current_statement__ = 104;
        check_greater_or_equal(function__, "J_item_neg[sym1__]",
                               J_item_neg[(sym1__ - 1)], 1);}
      current_statement__ = 105;
      context__.validate_dims("data initialization","N_item_equal","int",
          context__.to_vec());
      N_item_equal = std::numeric_limits<int>::min();
      
      current_statement__ = 105;
      N_item_equal = context__.vals_i("N_item_equal")[(1 - 1)];
      current_statement__ = 105;
      current_statement__ = 105;
      check_greater_or_equal(function__, "N_item_equal", N_item_equal, 0);
      current_statement__ = 106;
      validate_non_negative_index("J_item_equal", "N_item_equal",
                                  N_item_equal);
      current_statement__ = 107;
      context__.validate_dims("data initialization","J_item_equal","int",
          context__.to_vec(N_item_equal));
      J_item_equal = std::vector<int>(N_item_equal, std::numeric_limits<int>::min());
      
      current_statement__ = 107;
      assign(J_item_equal, nil_index_list(),
        context__.vals_i("J_item_equal"), "assigning variable J_item_equal");
      current_statement__ = 107;
      for (int sym1__ = 1; sym1__ <= N_item_equal; ++sym1__) {
        current_statement__ = 107;
        current_statement__ = 107;
        check_greater_or_equal(function__, "J_item_equal[sym1__]",
                               J_item_equal[(sym1__ - 1)], 1);}
      current_statement__ = 108;
      validate_non_negative_index("J_item_orig", "N_item_equal", N_item_equal);
      current_statement__ = 109;
      context__.validate_dims("data initialization","J_item_orig","int",
          context__.to_vec(N_item_equal));
      J_item_orig = std::vector<int>(N_item_equal, std::numeric_limits<int>::min());
      
      current_statement__ = 109;
      assign(J_item_orig, nil_index_list(), context__.vals_i("J_item_orig"),
        "assigning variable J_item_orig");
      current_statement__ = 109;
      for (int sym1__ = 1; sym1__ <= N_item_equal; ++sym1__) {
        current_statement__ = 109;
        current_statement__ = 109;
        check_greater_or_equal(function__, "J_item_orig[sym1__]",
                               J_item_orig[(sym1__ - 1)], 1);}
      current_statement__ = 110;
      context__.validate_dims("data initialization","ncat","int",
          context__.to_vec());
      ncat = std::numeric_limits<int>::min();
      
      current_statement__ = 110;
      ncat = context__.vals_i("ncat")[(1 - 1)];
      current_statement__ = 110;
      current_statement__ = 110;
      check_greater_or_equal(function__, "ncat", ncat, 2);
      current_statement__ = 111;
      validate_non_negative_index("psi_fix", "N_item_fix", N_item_fix);
      current_statement__ = 112;
      psi_fix = Eigen::Matrix<double, -1, 1>(N_item_fix);
      stan::math::fill(psi_fix, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 113;
      assign(psi_fix, nil_index_list(), rep_vector(1.0, N_item_fix),
        "assigning variable psi_fix");
      current_statement__ = 112;
      for (int sym1__ = 1; sym1__ <= N_item_fix; ++sym1__) {
        current_statement__ = 112;
        current_statement__ = 112;
        check_greater_or_equal(function__, "psi_fix[sym1__]",
                               psi_fix[(sym1__ - 1)], 0);}
      current_statement__ = 114;
      gamma_1dim__ = std::numeric_limits<int>::min();
      
      current_statement__ = 114;
      gamma_1dim__ = ((primitive_value((primitive_value(
                        logical_eq(family, 1)) || primitive_value(
                        logical_eq(family, 3)))) || primitive_value(
                        logical_eq(family, 4))) ? N_itemC : 0);
      current_statement__ = 114;
      validate_non_negative_index("gamma",
                                  "family == 1 || family == 3 || family == 4 ? N_itemC : 0",
                                  gamma_1dim__);
      current_statement__ = 115;
      gamma_ord_1dim__ = std::numeric_limits<int>::min();
      
      current_statement__ = 115;
      gamma_ord_1dim__ = (logical_eq(family, 2) ? N_itemC : 0);
      current_statement__ = 115;
      validate_non_negative_index("gamma_ord", "family == 2 ? N_itemC : 0",
                                  gamma_ord_1dim__);
      current_statement__ = 116;
      gamma_ord_2dim__ = std::numeric_limits<int>::min();
      
      current_statement__ = 116;
      gamma_ord_2dim__ = (ncat - 1);
      current_statement__ = 116;
      validate_non_negative_index("gamma_ord", "ncat - 1", gamma_ord_2dim__);
      current_statement__ = 117;
      validate_non_negative_index("lambda_pos", "N_item_pos", N_item_pos);
      current_statement__ = 118;
      validate_non_negative_index("lambda_neg", "N_item_neg", N_item_neg);
      current_statement__ = 119;
      validate_non_negative_index("psi_est", "N_item_est", N_item_est);
      current_statement__ = 120;
      validate_non_negative_index("z_trait", "N_trait", N_trait);
      current_statement__ = 121;
      validate_non_negative_index("z_trait", "N_person", N_person);
      current_statement__ = 122;
      validate_non_negative_index("L_trait", "N_trait", N_trait);
      current_statement__ = 122;
      validate_non_negative_index("L_trait", "N_trait", N_trait);
      current_statement__ = 123;
      validate_non_negative_index("z", "N_item", N_item);
      current_statement__ = 124;
      disp_1dim__ = std::numeric_limits<int>::min();
      
      current_statement__ = 124;
      disp_1dim__ = (logical_eq(family, 4) ? 1 : 0);
      current_statement__ = 124;
      validate_non_negative_index("disp", "family == 4 ? 1 : 0", disp_1dim__);
      current_statement__ = 125;
      validate_non_negative_index("eta", "N_person", N_person);
      current_statement__ = 126;
      validate_non_negative_index("eta", "N_trait", N_trait);
      current_statement__ = 127;
      validate_non_negative_index("lambda", "N_item", N_item);
      current_statement__ = 128;
      validate_non_negative_index("psi", "N_item", N_item);
      current_statement__ = 129;
      validate_non_negative_index("r", "N_item", N_item);
      current_statement__ = 130;
      validate_non_negative_index("Cor_trait", "N_trait", N_trait);
      current_statement__ = 130;
      validate_non_negative_index("Cor_trait", "N_trait", N_trait);
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
    }
    num_params_r__ = 0U;
    
    try {
      num_params_r__ += gamma_1dim__;
      num_params_r__ += gamma_ord_1dim__ * gamma_ord_2dim__;
      num_params_r__ += N_item_pos;
      num_params_r__ += N_item_neg;
      num_params_r__ += N_item_est;
      num_params_r__ += N_trait * N_person;
      num_params_r__ += ((N_trait * (N_trait - 1)) / 2);
      num_params_r__ += N_item;
      num_params_r__ += disp_1dim__;
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
    }
  }
  template <bool propto__, bool jacobian__, typename VecR, typename VecI, stan::require_vector_like_t<VecR>* = nullptr, stan::require_vector_like_vt<std::is_integral, VecI>* = nullptr>
  inline stan::scalar_type_t<VecR> log_prob_impl(VecR& params_r__,
                                                 VecI& params_i__,
                                                 std::ostream* pstream__ = nullptr) const {
    using T__ = stan::scalar_type_t<VecR>;
    using local_scalar_t__ = T__;
    T__ lp__(0.0);
    stan::math::accumulator<T__> lp_accum__;
    static const char* function__ = "model_thurstonian_irt_model_namespace::log_prob";
(void) function__;  // suppress unused var warning
    stan::io::reader<local_scalar_t__> in__(params_r__, params_i__);
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    (void) DUMMY_VAR__;  // suppress unused var warning
    
    try {
      Eigen::Matrix<local_scalar_t__, -1, 1> gamma;
      gamma = Eigen::Matrix<local_scalar_t__, -1, 1>(gamma_1dim__);
      stan::math::fill(gamma, DUMMY_VAR__);
      
      current_statement__ = 1;
      gamma = in__.vector(gamma_1dim__);
      std::vector<Eigen::Matrix<local_scalar_t__, -1, 1>> gamma_ord;
      gamma_ord = std::vector<Eigen::Matrix<local_scalar_t__, -1, 1>>(gamma_ord_1dim__, Eigen::Matrix<local_scalar_t__, -1, 1>(gamma_ord_2dim__));
      stan::math::fill(gamma_ord, DUMMY_VAR__);
      
      current_statement__ = 2;
      for (int sym1__ = 1; sym1__ <= gamma_ord_1dim__; ++sym1__) {
        current_statement__ = 2;
        assign(gamma_ord, cons_list(index_uni(sym1__), nil_index_list()),
          in__.vector(gamma_ord_2dim__), "assigning variable gamma_ord");}
      current_statement__ = 2;
      for (int sym1__ = 1; sym1__ <= gamma_ord_1dim__; ++sym1__) {
        current_statement__ = 2;
        if (jacobian__) {
          current_statement__ = 2;
          assign(gamma_ord, cons_list(index_uni(sym1__), nil_index_list()),
            stan::math::ordered_constrain(gamma_ord[(sym1__ - 1)], lp__),
            "assigning variable gamma_ord");
        } else {
          current_statement__ = 2;
          assign(gamma_ord, cons_list(index_uni(sym1__), nil_index_list()),
            stan::math::ordered_constrain(gamma_ord[(sym1__ - 1)]),
            "assigning variable gamma_ord");
        }}
      Eigen::Matrix<local_scalar_t__, -1, 1> lambda_pos;
      lambda_pos = Eigen::Matrix<local_scalar_t__, -1, 1>(N_item_pos);
      stan::math::fill(lambda_pos, DUMMY_VAR__);
      
      current_statement__ = 3;
      lambda_pos = in__.vector(N_item_pos);
      current_statement__ = 3;
      for (int sym1__ = 1; sym1__ <= N_item_pos; ++sym1__) {
        current_statement__ = 3;
        if (jacobian__) {
          current_statement__ = 3;
          assign(lambda_pos, cons_list(index_uni(sym1__), nil_index_list()),
            stan::math::lb_constrain(lambda_pos[(sym1__ - 1)], 0, lp__),
            "assigning variable lambda_pos");
        } else {
          current_statement__ = 3;
          assign(lambda_pos, cons_list(index_uni(sym1__), nil_index_list()),
            stan::math::lb_constrain(lambda_pos[(sym1__ - 1)], 0),
            "assigning variable lambda_pos");
        }}
      Eigen::Matrix<local_scalar_t__, -1, 1> lambda_neg;
      lambda_neg = Eigen::Matrix<local_scalar_t__, -1, 1>(N_item_neg);
      stan::math::fill(lambda_neg, DUMMY_VAR__);
      
      current_statement__ = 4;
      lambda_neg = in__.vector(N_item_neg);
      current_statement__ = 4;
      for (int sym1__ = 1; sym1__ <= N_item_neg; ++sym1__) {
        current_statement__ = 4;
        if (jacobian__) {
          current_statement__ = 4;
          assign(lambda_neg, cons_list(index_uni(sym1__), nil_index_list()),
            stan::math::ub_constrain(lambda_neg[(sym1__ - 1)], 0, lp__),
            "assigning variable lambda_neg");
        } else {
          current_statement__ = 4;
          assign(lambda_neg, cons_list(index_uni(sym1__), nil_index_list()),
            stan::math::ub_constrain(lambda_neg[(sym1__ - 1)], 0),
            "assigning variable lambda_neg");
        }}
      Eigen::Matrix<local_scalar_t__, -1, 1> psi_est;
      psi_est = Eigen::Matrix<local_scalar_t__, -1, 1>(N_item_est);
      stan::math::fill(psi_est, DUMMY_VAR__);
      
      current_statement__ = 5;
      psi_est = in__.vector(N_item_est);
      current_statement__ = 5;
      for (int sym1__ = 1; sym1__ <= N_item_est; ++sym1__) {
        current_statement__ = 5;
        if (jacobian__) {
          current_statement__ = 5;
          assign(psi_est, cons_list(index_uni(sym1__), nil_index_list()),
            stan::math::lb_constrain(psi_est[(sym1__ - 1)], 0, lp__),
            "assigning variable psi_est");
        } else {
          current_statement__ = 5;
          assign(psi_est, cons_list(index_uni(sym1__), nil_index_list()),
            stan::math::lb_constrain(psi_est[(sym1__ - 1)], 0),
            "assigning variable psi_est");
        }}
      Eigen::Matrix<local_scalar_t__, -1, -1> z_trait;
      z_trait = Eigen::Matrix<local_scalar_t__, -1, -1>(N_trait, N_person);
      stan::math::fill(z_trait, DUMMY_VAR__);
      
      current_statement__ = 6;
      z_trait = in__.matrix(N_trait, N_person);
      Eigen::Matrix<local_scalar_t__, -1, -1> L_trait;
      L_trait = Eigen::Matrix<local_scalar_t__, -1, -1>(N_trait, N_trait);
      stan::math::fill(L_trait, DUMMY_VAR__);
      
      Eigen::Matrix<local_scalar_t__, -1, 1> L_trait_in__;
      L_trait_in__ = Eigen::Matrix<local_scalar_t__, -1, 1>(((N_trait *
                                                               (N_trait - 1))
                                                              / 2));
      stan::math::fill(L_trait_in__, DUMMY_VAR__);
      
      current_statement__ = 7;
      L_trait_in__ = in__.vector(((N_trait * (N_trait - 1)) / 2));
      current_statement__ = 7;
      if (jacobian__) {
        current_statement__ = 7;
        assign(L_trait, nil_index_list(),
          stan::math::cholesky_corr_constrain(L_trait_in__, N_trait, lp__),
          "assigning variable L_trait");
      } else {
        current_statement__ = 7;
        assign(L_trait, nil_index_list(),
          stan::math::cholesky_corr_constrain(L_trait_in__, N_trait),
          "assigning variable L_trait");
      }
      Eigen::Matrix<local_scalar_t__, -1, 1> z;
      z = Eigen::Matrix<local_scalar_t__, -1, 1>(N_item);
      stan::math::fill(z, DUMMY_VAR__);
      
      current_statement__ = 8;
      z = in__.vector(N_item);
      Eigen::Matrix<local_scalar_t__, -1, 1> disp;
      disp = Eigen::Matrix<local_scalar_t__, -1, 1>(disp_1dim__);
      stan::math::fill(disp, DUMMY_VAR__);
      
      current_statement__ = 9;
      disp = in__.vector(disp_1dim__);
      current_statement__ = 9;
      for (int sym1__ = 1; sym1__ <= disp_1dim__; ++sym1__) {
        current_statement__ = 9;
        if (jacobian__) {
          current_statement__ = 9;
          assign(disp, cons_list(index_uni(sym1__), nil_index_list()),
            stan::math::lb_constrain(disp[(sym1__ - 1)], 0, lp__),
            "assigning variable disp");
        } else {
          current_statement__ = 9;
          assign(disp, cons_list(index_uni(sym1__), nil_index_list()),
            stan::math::lb_constrain(disp[(sym1__ - 1)], 0),
            "assigning variable disp");
        }}
      Eigen::Matrix<local_scalar_t__, -1, -1> eta;
      eta = Eigen::Matrix<local_scalar_t__, -1, -1>(N_person, N_trait);
      stan::math::fill(eta, DUMMY_VAR__);
      
      Eigen::Matrix<local_scalar_t__, -1, 1> lambda;
      lambda = Eigen::Matrix<local_scalar_t__, -1, 1>(N_item);
      stan::math::fill(lambda, DUMMY_VAR__);
      
      Eigen::Matrix<local_scalar_t__, -1, 1> psi;
      psi = Eigen::Matrix<local_scalar_t__, -1, 1>(N_item);
      stan::math::fill(psi, DUMMY_VAR__);
      
      Eigen::Matrix<local_scalar_t__, -1, 1> r;
      r = Eigen::Matrix<local_scalar_t__, -1, 1>(N_item);
      stan::math::fill(r, DUMMY_VAR__);
      
      current_statement__ = 14;
      assign(eta, nil_index_list(), transpose(multiply(L_trait, z_trait)),
        "assigning variable eta");
      current_statement__ = 15;
      assign(psi, cons_list(index_multi(J_item_fix), nil_index_list()),
        psi_fix, "assigning variable psi");
      current_statement__ = 16;
      assign(psi, cons_list(index_multi(J_item_est), nil_index_list()),
        psi_est, "assigning variable psi");
      current_statement__ = 17;
      assign(psi, cons_list(index_multi(J_item_equal), nil_index_list()),
        stan::model::deep_copy(
          rvalue(psi, cons_list(index_multi(J_item_orig), nil_index_list()),
            "psi")), "assigning variable psi");
      current_statement__ = 18;
      assign(lambda, cons_list(index_multi(J_item_pos), nil_index_list()),
        lambda_pos, "assigning variable lambda");
      current_statement__ = 19;
      assign(lambda, cons_list(index_multi(J_item_neg), nil_index_list()),
        lambda_neg, "assigning variable lambda");
      current_statement__ = 20;
      assign(lambda, cons_list(index_multi(J_item_equal), nil_index_list()),
        stan::model::deep_copy(
          rvalue(lambda,
            cons_list(index_multi(J_item_orig), nil_index_list()), "lambda")),
        "assigning variable lambda");
      current_statement__ = 21;
      assign(r, nil_index_list(), elt_multiply(psi, z),
        "assigning variable r");
      current_statement__ = 12;
      for (int sym1__ = 1; sym1__ <= N_item; ++sym1__) {
        current_statement__ = 12;
        current_statement__ = 12;
        check_greater_or_equal(function__, "psi[sym1__]", psi[(sym1__ - 1)],
                               0);}
      {
        current_statement__ = 24;
        validate_non_negative_index("mu", "N", N);
        Eigen::Matrix<local_scalar_t__, -1, 1> mu;
        mu = Eigen::Matrix<local_scalar_t__, -1, 1>(N);
        stan::math::fill(mu, DUMMY_VAR__);
        
        current_statement__ = 26;
        validate_non_negative_index("sum_psi", "N", N);
        Eigen::Matrix<local_scalar_t__, -1, 1> sum_psi;
        sum_psi = Eigen::Matrix<local_scalar_t__, -1, 1>(N);
        stan::math::fill(sum_psi, DUMMY_VAR__);
        
        current_statement__ = 31;
        for (int n = 1; n <= N; ++n) {
          current_statement__ = 28;
          assign(mu, cons_list(index_uni(n), nil_index_list()),
            (((r[(J_item1[(n - 1)] - 1)] - r[(J_item2[(n - 1)] - 1)]) +
               (lambda[(J_item1[(n - 1)] - 1)] *
                 rvalue(eta,
                   cons_list(index_uni(J_person[(n - 1)]),
                     cons_list(index_uni(J_trait1[(n - 1)]),
                       nil_index_list())), "eta"))) -
              (lambda[(J_item2[(n - 1)] - 1)] *
                rvalue(eta,
                  cons_list(index_uni(J_person[(n - 1)]),
                    cons_list(index_uni(J_trait2[(n - 1)]), nil_index_list())),
                  "eta"))), "assigning variable mu");
          current_statement__ = 29;
          assign(sum_psi, cons_list(index_uni(n), nil_index_list()),
            stan::math::sqrt(
              (pow(psi[(J_item1[(n - 1)] - 1)], 2) +
                pow(psi[(J_item2[(n - 1)] - 1)], 2))),
            "assigning variable sum_psi");}
        current_statement__ = 57;
        if (logical_eq(family, 1)) {
          current_statement__ = 54;
          for (int n = 1; n <= N; ++n) {
            current_statement__ = 52;
            assign(mu, cons_list(index_uni(n), nil_index_list()),
              Phi(
                ((mu[(n - 1)] - gamma[(J_itemC[(n - 1)] - 1)]) /
                  sum_psi[(n - 1)])), "assigning variable mu");}
          current_statement__ = 55;
          lp_accum__.add(bernoulli_lpmf<propto__>(Yint, mu));
        } else {
          current_statement__ = 51;
          if (logical_eq(family, 2)) {
            current_statement__ = 49;
            for (int n = 1; n <= N; ++n) {
              current_statement__ = 44;
              validate_non_negative_index("thres", "ncat - 1", (ncat - 1));
              Eigen::Matrix<local_scalar_t__, -1, 1> thres;
              thres = Eigen::Matrix<local_scalar_t__, -1, 1>((ncat - 1));
              stan::math::fill(thres, DUMMY_VAR__);
              
              current_statement__ = 45;
              assign(thres, nil_index_list(),
                divide(gamma_ord[(J_itemC[(n - 1)] - 1)], sum_psi[(n - 1)]),
                "assigning variable thres");
              current_statement__ = 46;
              assign(mu, cons_list(index_uni(n), nil_index_list()),
                (mu[(n - 1)] / sum_psi[(n - 1)]), "assigning variable mu");
              current_statement__ = 47;
              lp_accum__.add(
                cumulative_Phi_lpmf<propto__>(Yint[(n - 1)], mu[(n - 1)],
                  thres, pstream__));}
          } else {
            current_statement__ = 43;
            if (logical_eq(family, 3)) {
              current_statement__ = 40;
              for (int n = 1; n <= N; ++n) {
                current_statement__ = 38;
                assign(mu, cons_list(index_uni(n), nil_index_list()),
                  (mu[(n - 1)] - gamma[(J_itemC[(n - 1)] - 1)]),
                  "assigning variable mu");}
              current_statement__ = 41;
              lp_accum__.add(normal_lpdf<propto__>(Yreal, mu, 1));
            } else {
              current_statement__ = 37;
              if (logical_eq(family, 4)) {
                current_statement__ = 34;
                for (int n = 1; n <= N; ++n) {
                  current_statement__ = 32;
                  assign(mu, cons_list(index_uni(n), nil_index_list()),
                    Phi(
                      ((mu[(n - 1)] - gamma[(J_itemC[(n - 1)] - 1)]) /
                        sum_psi[(n - 1)])), "assigning variable mu");}
                current_statement__ = 35;
                lp_accum__.add(
                  beta_lpdf<propto__>(Yreal, multiply(mu, disp[(1 - 1)]),
                    multiply(subtract(1, mu), disp[(1 - 1)])));
              } 
            }
          }
        }
        current_statement__ = 64;
        if (logical_eq(family, 2)) {
          current_statement__ = 62;
          for (int i = 1; i <= N_itemC; ++i) {
            current_statement__ = 60;
            lp_accum__.add(normal_lpdf<propto__>(gamma_ord[(i - 1)], 0, 3));}
        } else {
          current_statement__ = 58;
          lp_accum__.add(normal_lpdf<propto__>(gamma, 0, 3));
        }
        current_statement__ = 65;
        lp_accum__.add(normal_lpdf<propto__>(lambda_pos, 1, 0.5));
        current_statement__ = 66;
        lp_accum__.add(normal_lpdf<propto__>(lambda_neg, -1, 0.5));
        current_statement__ = 67;
        lp_accum__.add(normal_lpdf<propto__>(psi_est, 1, 0.3));
        current_statement__ = 68;
        lp_accum__.add(lkj_corr_cholesky_lpdf<propto__>(L_trait, 1));
        current_statement__ = 69;
        lp_accum__.add(normal_lpdf<propto__>(to_vector(z_trait), 0, 1));
        current_statement__ = 70;
        lp_accum__.add(normal_lpdf<propto__>(z, 0, 1));
      }
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
    }
    lp_accum__.add(lp__);
    return lp_accum__.sum();
    } // log_prob_impl() 
    
  template <typename RNG, typename VecR, typename VecI, typename VecVar, stan::require_vector_like_vt<std::is_floating_point, VecR>* = nullptr, stan::require_vector_like_vt<std::is_integral, VecI>* = nullptr, stan::require_std_vector_vt<std::is_floating_point, VecVar>* = nullptr>
  inline void write_array_impl(RNG& base_rng__, VecR& params_r__,
                               VecI& params_i__, VecVar& vars__,
                               const bool emit_transformed_parameters__ = true,
                               const bool emit_generated_quantities__ = true,
                               std::ostream* pstream__ = nullptr) const {
    using local_scalar_t__ = double;
    vars__.resize(0);
    stan::io::reader<local_scalar_t__> in__(params_r__, params_i__);
    static const char* function__ = "model_thurstonian_irt_model_namespace::write_array";
(void) function__;  // suppress unused var warning
    (void) function__;  // suppress unused var warning
    double lp__ = 0.0;
    (void) lp__;  // dummy to suppress unused var warning
    stan::math::accumulator<double> lp_accum__;
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    (void) DUMMY_VAR__;  // suppress unused var warning
    
    try {
      Eigen::Matrix<double, -1, 1> gamma;
      gamma = Eigen::Matrix<double, -1, 1>(gamma_1dim__);
      stan::math::fill(gamma, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 1;
      gamma = in__.vector(gamma_1dim__);
      std::vector<Eigen::Matrix<double, -1, 1>> gamma_ord;
      gamma_ord = std::vector<Eigen::Matrix<double, -1, 1>>(gamma_ord_1dim__, Eigen::Matrix<double, -1, 1>(gamma_ord_2dim__));
      stan::math::fill(gamma_ord, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 2;
      for (int sym1__ = 1; sym1__ <= gamma_ord_1dim__; ++sym1__) {
        current_statement__ = 2;
        assign(gamma_ord, cons_list(index_uni(sym1__), nil_index_list()),
          in__.vector(gamma_ord_2dim__), "assigning variable gamma_ord");}
      current_statement__ = 2;
      for (int sym1__ = 1; sym1__ <= gamma_ord_1dim__; ++sym1__) {
        current_statement__ = 2;
        assign(gamma_ord, cons_list(index_uni(sym1__), nil_index_list()),
          stan::math::ordered_constrain(gamma_ord[(sym1__ - 1)]),
          "assigning variable gamma_ord");}
      Eigen::Matrix<double, -1, 1> lambda_pos;
      lambda_pos = Eigen::Matrix<double, -1, 1>(N_item_pos);
      stan::math::fill(lambda_pos, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 3;
      lambda_pos = in__.vector(N_item_pos);
      current_statement__ = 3;
      for (int sym1__ = 1; sym1__ <= N_item_pos; ++sym1__) {
        current_statement__ = 3;
        assign(lambda_pos, cons_list(index_uni(sym1__), nil_index_list()),
          stan::math::lb_constrain(lambda_pos[(sym1__ - 1)], 0),
          "assigning variable lambda_pos");}
      Eigen::Matrix<double, -1, 1> lambda_neg;
      lambda_neg = Eigen::Matrix<double, -1, 1>(N_item_neg);
      stan::math::fill(lambda_neg, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 4;
      lambda_neg = in__.vector(N_item_neg);
      current_statement__ = 4;
      for (int sym1__ = 1; sym1__ <= N_item_neg; ++sym1__) {
        current_statement__ = 4;
        assign(lambda_neg, cons_list(index_uni(sym1__), nil_index_list()),
          stan::math::ub_constrain(lambda_neg[(sym1__ - 1)], 0),
          "assigning variable lambda_neg");}
      Eigen::Matrix<double, -1, 1> psi_est;
      psi_est = Eigen::Matrix<double, -1, 1>(N_item_est);
      stan::math::fill(psi_est, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 5;
      psi_est = in__.vector(N_item_est);
      current_statement__ = 5;
      for (int sym1__ = 1; sym1__ <= N_item_est; ++sym1__) {
        current_statement__ = 5;
        assign(psi_est, cons_list(index_uni(sym1__), nil_index_list()),
          stan::math::lb_constrain(psi_est[(sym1__ - 1)], 0),
          "assigning variable psi_est");}
      Eigen::Matrix<double, -1, -1> z_trait;
      z_trait = Eigen::Matrix<double, -1, -1>(N_trait, N_person);
      stan::math::fill(z_trait, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 6;
      z_trait = in__.matrix(N_trait, N_person);
      Eigen::Matrix<double, -1, -1> L_trait;
      L_trait = Eigen::Matrix<double, -1, -1>(N_trait, N_trait);
      stan::math::fill(L_trait, std::numeric_limits<double>::quiet_NaN());
      
      Eigen::Matrix<local_scalar_t__, -1, 1> L_trait_in__;
      L_trait_in__ = Eigen::Matrix<local_scalar_t__, -1, 1>(((N_trait *
                                                               (N_trait - 1))
                                                              / 2));
      stan::math::fill(L_trait_in__, DUMMY_VAR__);
      
      current_statement__ = 7;
      L_trait_in__ = in__.vector(((N_trait * (N_trait - 1)) / 2));
      current_statement__ = 7;
      assign(L_trait, nil_index_list(),
        stan::math::cholesky_corr_constrain(L_trait_in__, N_trait),
        "assigning variable L_trait");
      Eigen::Matrix<double, -1, 1> z;
      z = Eigen::Matrix<double, -1, 1>(N_item);
      stan::math::fill(z, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 8;
      z = in__.vector(N_item);
      Eigen::Matrix<double, -1, 1> disp;
      disp = Eigen::Matrix<double, -1, 1>(disp_1dim__);
      stan::math::fill(disp, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 9;
      disp = in__.vector(disp_1dim__);
      current_statement__ = 9;
      for (int sym1__ = 1; sym1__ <= disp_1dim__; ++sym1__) {
        current_statement__ = 9;
        assign(disp, cons_list(index_uni(sym1__), nil_index_list()),
          stan::math::lb_constrain(disp[(sym1__ - 1)], 0),
          "assigning variable disp");}
      Eigen::Matrix<double, -1, -1> eta;
      eta = Eigen::Matrix<double, -1, -1>(N_person, N_trait);
      stan::math::fill(eta, std::numeric_limits<double>::quiet_NaN());
      
      Eigen::Matrix<double, -1, 1> lambda;
      lambda = Eigen::Matrix<double, -1, 1>(N_item);
      stan::math::fill(lambda, std::numeric_limits<double>::quiet_NaN());
      
      Eigen::Matrix<double, -1, 1> psi;
      psi = Eigen::Matrix<double, -1, 1>(N_item);
      stan::math::fill(psi, std::numeric_limits<double>::quiet_NaN());
      
      Eigen::Matrix<double, -1, 1> r;
      r = Eigen::Matrix<double, -1, 1>(N_item);
      stan::math::fill(r, std::numeric_limits<double>::quiet_NaN());
      
      for (int sym1__ = 1; sym1__ <= gamma_1dim__; ++sym1__) {
        vars__.emplace_back(gamma[(sym1__ - 1)]);}
      for (int sym1__ = 1; sym1__ <= gamma_ord_2dim__; ++sym1__) {
        for (int sym2__ = 1; sym2__ <= gamma_ord_1dim__; ++sym2__) {
          vars__.emplace_back(gamma_ord[(sym2__ - 1)][(sym1__ - 1)]);}}
      for (int sym1__ = 1; sym1__ <= N_item_pos; ++sym1__) {
        vars__.emplace_back(lambda_pos[(sym1__ - 1)]);}
      for (int sym1__ = 1; sym1__ <= N_item_neg; ++sym1__) {
        vars__.emplace_back(lambda_neg[(sym1__ - 1)]);}
      for (int sym1__ = 1; sym1__ <= N_item_est; ++sym1__) {
        vars__.emplace_back(psi_est[(sym1__ - 1)]);}
      for (int sym1__ = 1; sym1__ <= N_person; ++sym1__) {
        for (int sym2__ = 1; sym2__ <= N_trait; ++sym2__) {
          vars__.emplace_back(
            rvalue(z_trait,
              cons_list(index_uni(sym2__),
                cons_list(index_uni(sym1__), nil_index_list())), "z_trait"));
        }}
      for (int sym1__ = 1; sym1__ <= N_trait; ++sym1__) {
        for (int sym2__ = 1; sym2__ <= N_trait; ++sym2__) {
          vars__.emplace_back(
            rvalue(L_trait,
              cons_list(index_uni(sym2__),
                cons_list(index_uni(sym1__), nil_index_list())), "L_trait"));
        }}
      for (int sym1__ = 1; sym1__ <= N_item; ++sym1__) {
        vars__.emplace_back(z[(sym1__ - 1)]);}
      for (int sym1__ = 1; sym1__ <= disp_1dim__; ++sym1__) {
        vars__.emplace_back(disp[(sym1__ - 1)]);}
      if (logical_negation((primitive_value(emit_transformed_parameters__) ||
            primitive_value(emit_generated_quantities__)))) {
        return ;
      } 
      current_statement__ = 14;
      assign(eta, nil_index_list(), transpose(multiply(L_trait, z_trait)),
        "assigning variable eta");
      current_statement__ = 15;
      assign(psi, cons_list(index_multi(J_item_fix), nil_index_list()),
        psi_fix, "assigning variable psi");
      current_statement__ = 16;
      assign(psi, cons_list(index_multi(J_item_est), nil_index_list()),
        psi_est, "assigning variable psi");
      current_statement__ = 17;
      assign(psi, cons_list(index_multi(J_item_equal), nil_index_list()),
        stan::model::deep_copy(
          rvalue(psi, cons_list(index_multi(J_item_orig), nil_index_list()),
            "psi")), "assigning variable psi");
      current_statement__ = 18;
      assign(lambda, cons_list(index_multi(J_item_pos), nil_index_list()),
        lambda_pos, "assigning variable lambda");
      current_statement__ = 19;
      assign(lambda, cons_list(index_multi(J_item_neg), nil_index_list()),
        lambda_neg, "assigning variable lambda");
      current_statement__ = 20;
      assign(lambda, cons_list(index_multi(J_item_equal), nil_index_list()),
        stan::model::deep_copy(
          rvalue(lambda,
            cons_list(index_multi(J_item_orig), nil_index_list()), "lambda")),
        "assigning variable lambda");
      current_statement__ = 21;
      assign(r, nil_index_list(), elt_multiply(psi, z),
        "assigning variable r");
      current_statement__ = 12;
      for (int sym1__ = 1; sym1__ <= N_item; ++sym1__) {
        current_statement__ = 12;
        current_statement__ = 12;
        check_greater_or_equal(function__, "psi[sym1__]", psi[(sym1__ - 1)],
                               0);}
      if (emit_transformed_parameters__) {
        for (int sym1__ = 1; sym1__ <= N_trait; ++sym1__) {
          for (int sym2__ = 1; sym2__ <= N_person; ++sym2__) {
            vars__.emplace_back(
              rvalue(eta,
                cons_list(index_uni(sym2__),
                  cons_list(index_uni(sym1__), nil_index_list())), "eta"));}}
        for (int sym1__ = 1; sym1__ <= N_item; ++sym1__) {
          vars__.emplace_back(lambda[(sym1__ - 1)]);}
        for (int sym1__ = 1; sym1__ <= N_item; ++sym1__) {
          vars__.emplace_back(psi[(sym1__ - 1)]);}
        for (int sym1__ = 1; sym1__ <= N_item; ++sym1__) {
          vars__.emplace_back(r[(sym1__ - 1)]);}
      } 
      if (logical_negation(emit_generated_quantities__)) {
        return ;
      } 
      Eigen::Matrix<double, -1, -1> Cor_trait;
      Cor_trait = Eigen::Matrix<double, -1, -1>(N_trait, N_trait);
      stan::math::fill(Cor_trait, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 23;
      assign(Cor_trait, nil_index_list(),
        multiply_lower_tri_self_transpose(L_trait),
        "assigning variable Cor_trait");
      current_statement__ = 22;
      current_statement__ = 22;
      check_corr_matrix(function__, "Cor_trait", Cor_trait);
      for (int sym1__ = 1; sym1__ <= N_trait; ++sym1__) {
        for (int sym2__ = 1; sym2__ <= N_trait; ++sym2__) {
          vars__.emplace_back(
            rvalue(Cor_trait,
              cons_list(index_uni(sym2__),
                cons_list(index_uni(sym1__), nil_index_list())), "Cor_trait"));
        }}
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
    }
    } // write_array_impl() 
    
  template <typename VecVar, typename VecI, stan::require_std_vector_t<VecVar>* = nullptr, stan::require_vector_like_vt<std::is_integral, VecI>* = nullptr>
  inline void transform_inits_impl(const stan::io::var_context& context__,
                                   VecI& params_i__, VecVar& vars__,
                                   std::ostream* pstream__ = nullptr) const {
    using local_scalar_t__ = double;
    vars__.clear();
    vars__.reserve(num_params_r__);
    
    try {
      int pos__;
      pos__ = std::numeric_limits<int>::min();
      
      pos__ = 1;
      Eigen::Matrix<double, -1, 1> gamma;
      gamma = Eigen::Matrix<double, -1, 1>(gamma_1dim__);
      stan::math::fill(gamma, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> gamma_flat__;
        current_statement__ = 1;
        assign(gamma_flat__, nil_index_list(), context__.vals_r("gamma"),
          "assigning variable gamma_flat__");
        current_statement__ = 1;
        pos__ = 1;
        current_statement__ = 1;
        for (int sym1__ = 1; sym1__ <= gamma_1dim__; ++sym1__) {
          current_statement__ = 1;
          assign(gamma, cons_list(index_uni(sym1__), nil_index_list()),
            gamma_flat__[(pos__ - 1)], "assigning variable gamma");
          current_statement__ = 1;
          pos__ = (pos__ + 1);}
      }
      std::vector<Eigen::Matrix<double, -1, 1>> gamma_ord;
      gamma_ord = std::vector<Eigen::Matrix<double, -1, 1>>(gamma_ord_1dim__, Eigen::Matrix<double, -1, 1>(gamma_ord_2dim__));
      stan::math::fill(gamma_ord, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> gamma_ord_flat__;
        current_statement__ = 2;
        assign(gamma_ord_flat__, nil_index_list(),
          context__.vals_r("gamma_ord"),
          "assigning variable gamma_ord_flat__");
        current_statement__ = 2;
        pos__ = 1;
        current_statement__ = 2;
        for (int sym1__ = 1; sym1__ <= gamma_ord_2dim__; ++sym1__) {
          current_statement__ = 2;
          for (int sym2__ = 1; sym2__ <= gamma_ord_1dim__; ++sym2__) {
            current_statement__ = 2;
            assign(gamma_ord,
              cons_list(index_uni(sym2__),
                cons_list(index_uni(sym1__), nil_index_list())),
              gamma_ord_flat__[(pos__ - 1)], "assigning variable gamma_ord");
            current_statement__ = 2;
            pos__ = (pos__ + 1);}}
      }
      std::vector<Eigen::Matrix<double, -1, 1>> gamma_ord_free__;
      gamma_ord_free__ = std::vector<Eigen::Matrix<double, -1, 1>>(gamma_ord_1dim__, Eigen::Matrix<double, -1, 1>(gamma_ord_2dim__));
      stan::math::fill(gamma_ord_free__, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 2;
      for (int sym1__ = 1; sym1__ <= gamma_ord_1dim__; ++sym1__) {
        current_statement__ = 2;
        assign(gamma_ord_free__,
          cons_list(index_uni(sym1__), nil_index_list()),
          stan::math::ordered_free(gamma_ord[(sym1__ - 1)]),
          "assigning variable gamma_ord_free__");}
      Eigen::Matrix<double, -1, 1> lambda_pos;
      lambda_pos = Eigen::Matrix<double, -1, 1>(N_item_pos);
      stan::math::fill(lambda_pos, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> lambda_pos_flat__;
        current_statement__ = 3;
        assign(lambda_pos_flat__, nil_index_list(),
          context__.vals_r("lambda_pos"),
          "assigning variable lambda_pos_flat__");
        current_statement__ = 3;
        pos__ = 1;
        current_statement__ = 3;
        for (int sym1__ = 1; sym1__ <= N_item_pos; ++sym1__) {
          current_statement__ = 3;
          assign(lambda_pos, cons_list(index_uni(sym1__), nil_index_list()),
            lambda_pos_flat__[(pos__ - 1)], "assigning variable lambda_pos");
          current_statement__ = 3;
          pos__ = (pos__ + 1);}
      }
      Eigen::Matrix<double, -1, 1> lambda_pos_free__;
      lambda_pos_free__ = Eigen::Matrix<double, -1, 1>(N_item_pos);
      stan::math::fill(lambda_pos_free__, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 3;
      for (int sym1__ = 1; sym1__ <= N_item_pos; ++sym1__) {
        current_statement__ = 3;
        assign(lambda_pos_free__,
          cons_list(index_uni(sym1__), nil_index_list()),
          stan::math::lb_free(lambda_pos[(sym1__ - 1)], 0),
          "assigning variable lambda_pos_free__");}
      Eigen::Matrix<double, -1, 1> lambda_neg;
      lambda_neg = Eigen::Matrix<double, -1, 1>(N_item_neg);
      stan::math::fill(lambda_neg, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> lambda_neg_flat__;
        current_statement__ = 4;
        assign(lambda_neg_flat__, nil_index_list(),
          context__.vals_r("lambda_neg"),
          "assigning variable lambda_neg_flat__");
        current_statement__ = 4;
        pos__ = 1;
        current_statement__ = 4;
        for (int sym1__ = 1; sym1__ <= N_item_neg; ++sym1__) {
          current_statement__ = 4;
          assign(lambda_neg, cons_list(index_uni(sym1__), nil_index_list()),
            lambda_neg_flat__[(pos__ - 1)], "assigning variable lambda_neg");
          current_statement__ = 4;
          pos__ = (pos__ + 1);}
      }
      Eigen::Matrix<double, -1, 1> lambda_neg_free__;
      lambda_neg_free__ = Eigen::Matrix<double, -1, 1>(N_item_neg);
      stan::math::fill(lambda_neg_free__, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 4;
      for (int sym1__ = 1; sym1__ <= N_item_neg; ++sym1__) {
        current_statement__ = 4;
        assign(lambda_neg_free__,
          cons_list(index_uni(sym1__), nil_index_list()),
          stan::math::ub_free(lambda_neg[(sym1__ - 1)], 0),
          "assigning variable lambda_neg_free__");}
      Eigen::Matrix<double, -1, 1> psi_est;
      psi_est = Eigen::Matrix<double, -1, 1>(N_item_est);
      stan::math::fill(psi_est, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> psi_est_flat__;
        current_statement__ = 5;
        assign(psi_est_flat__, nil_index_list(), context__.vals_r("psi_est"),
          "assigning variable psi_est_flat__");
        current_statement__ = 5;
        pos__ = 1;
        current_statement__ = 5;
        for (int sym1__ = 1; sym1__ <= N_item_est; ++sym1__) {
          current_statement__ = 5;
          assign(psi_est, cons_list(index_uni(sym1__), nil_index_list()),
            psi_est_flat__[(pos__ - 1)], "assigning variable psi_est");
          current_statement__ = 5;
          pos__ = (pos__ + 1);}
      }
      Eigen::Matrix<double, -1, 1> psi_est_free__;
      psi_est_free__ = Eigen::Matrix<double, -1, 1>(N_item_est);
      stan::math::fill(psi_est_free__, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 5;
      for (int sym1__ = 1; sym1__ <= N_item_est; ++sym1__) {
        current_statement__ = 5;
        assign(psi_est_free__,
          cons_list(index_uni(sym1__), nil_index_list()),
          stan::math::lb_free(psi_est[(sym1__ - 1)], 0),
          "assigning variable psi_est_free__");}
      Eigen::Matrix<double, -1, -1> z_trait;
      z_trait = Eigen::Matrix<double, -1, -1>(N_trait, N_person);
      stan::math::fill(z_trait, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> z_trait_flat__;
        current_statement__ = 6;
        assign(z_trait_flat__, nil_index_list(), context__.vals_r("z_trait"),
          "assigning variable z_trait_flat__");
        current_statement__ = 6;
        pos__ = 1;
        current_statement__ = 6;
        for (int sym1__ = 1; sym1__ <= N_person; ++sym1__) {
          current_statement__ = 6;
          for (int sym2__ = 1; sym2__ <= N_trait; ++sym2__) {
            current_statement__ = 6;
            assign(z_trait,
              cons_list(index_uni(sym2__),
                cons_list(index_uni(sym1__), nil_index_list())),
              z_trait_flat__[(pos__ - 1)], "assigning variable z_trait");
            current_statement__ = 6;
            pos__ = (pos__ + 1);}}
      }
      Eigen::Matrix<double, -1, -1> L_trait;
      L_trait = Eigen::Matrix<double, -1, -1>(N_trait, N_trait);
      stan::math::fill(L_trait, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> L_trait_flat__;
        current_statement__ = 7;
        assign(L_trait_flat__, nil_index_list(), context__.vals_r("L_trait"),
          "assigning variable L_trait_flat__");
        current_statement__ = 7;
        pos__ = 1;
        current_statement__ = 7;
        for (int sym1__ = 1; sym1__ <= N_trait; ++sym1__) {
          current_statement__ = 7;
          for (int sym2__ = 1; sym2__ <= N_trait; ++sym2__) {
            current_statement__ = 7;
            assign(L_trait,
              cons_list(index_uni(sym2__),
                cons_list(index_uni(sym1__), nil_index_list())),
              L_trait_flat__[(pos__ - 1)], "assigning variable L_trait");
            current_statement__ = 7;
            pos__ = (pos__ + 1);}}
      }
      Eigen::Matrix<double, -1, 1> L_trait_free__;
      L_trait_free__ = Eigen::Matrix<double, -1, 1>(((N_trait *
                                                       (N_trait - 1)) / 2));
      stan::math::fill(L_trait_free__, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 7;
      assign(L_trait_free__, nil_index_list(),
        stan::math::cholesky_corr_free(L_trait),
        "assigning variable L_trait_free__");
      Eigen::Matrix<double, -1, 1> z;
      z = Eigen::Matrix<double, -1, 1>(N_item);
      stan::math::fill(z, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> z_flat__;
        current_statement__ = 8;
        assign(z_flat__, nil_index_list(), context__.vals_r("z"),
          "assigning variable z_flat__");
        current_statement__ = 8;
        pos__ = 1;
        current_statement__ = 8;
        for (int sym1__ = 1; sym1__ <= N_item; ++sym1__) {
          current_statement__ = 8;
          assign(z, cons_list(index_uni(sym1__), nil_index_list()),
            z_flat__[(pos__ - 1)], "assigning variable z");
          current_statement__ = 8;
          pos__ = (pos__ + 1);}
      }
      Eigen::Matrix<double, -1, 1> disp;
      disp = Eigen::Matrix<double, -1, 1>(disp_1dim__);
      stan::math::fill(disp, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> disp_flat__;
        current_statement__ = 9;
        assign(disp_flat__, nil_index_list(), context__.vals_r("disp"),
          "assigning variable disp_flat__");
        current_statement__ = 9;
        pos__ = 1;
        current_statement__ = 9;
        for (int sym1__ = 1; sym1__ <= disp_1dim__; ++sym1__) {
          current_statement__ = 9;
          assign(disp, cons_list(index_uni(sym1__), nil_index_list()),
            disp_flat__[(pos__ - 1)], "assigning variable disp");
          current_statement__ = 9;
          pos__ = (pos__ + 1);}
      }
      Eigen::Matrix<double, -1, 1> disp_free__;
      disp_free__ = Eigen::Matrix<double, -1, 1>(disp_1dim__);
      stan::math::fill(disp_free__, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 9;
      for (int sym1__ = 1; sym1__ <= disp_1dim__; ++sym1__) {
        current_statement__ = 9;
        assign(disp_free__, cons_list(index_uni(sym1__), nil_index_list()),
          stan::math::lb_free(disp[(sym1__ - 1)], 0),
          "assigning variable disp_free__");}
      for (int sym1__ = 1; sym1__ <= gamma_1dim__; ++sym1__) {
        vars__.emplace_back(gamma[(sym1__ - 1)]);}
      for (int sym1__ = 1; sym1__ <= gamma_ord_1dim__; ++sym1__) {
        for (int sym2__ = 1; sym2__ <= gamma_ord_2dim__; ++sym2__) {
          vars__.emplace_back(gamma_ord_free__[(sym1__ - 1)][(sym2__ - 1)]);}
      }
      for (int sym1__ = 1; sym1__ <= N_item_pos; ++sym1__) {
        vars__.emplace_back(lambda_pos_free__[(sym1__ - 1)]);}
      for (int sym1__ = 1; sym1__ <= N_item_neg; ++sym1__) {
        vars__.emplace_back(lambda_neg_free__[(sym1__ - 1)]);}
      for (int sym1__ = 1; sym1__ <= N_item_est; ++sym1__) {
        vars__.emplace_back(psi_est_free__[(sym1__ - 1)]);}
      for (int sym1__ = 1; sym1__ <= N_person; ++sym1__) {
        for (int sym2__ = 1; sym2__ <= N_trait; ++sym2__) {
          vars__.emplace_back(
            rvalue(z_trait,
              cons_list(index_uni(sym2__),
                cons_list(index_uni(sym1__), nil_index_list())), "z_trait"));
        }}
      for (int sym1__ = 1; sym1__ <= ((N_trait * (N_trait - 1)) / 2);
           ++sym1__) { vars__.emplace_back(L_trait_free__[(sym1__ - 1)]);}
      for (int sym1__ = 1; sym1__ <= N_item; ++sym1__) {
        vars__.emplace_back(z[(sym1__ - 1)]);}
      for (int sym1__ = 1; sym1__ <= disp_1dim__; ++sym1__) {
        vars__.emplace_back(disp_free__[(sym1__ - 1)]);}
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
    }
    } // transform_inits_impl() 
    
  inline void get_param_names(std::vector<std::string>& names__) const {
    
    names__.clear();
    names__.emplace_back("gamma");
    names__.emplace_back("gamma_ord");
    names__.emplace_back("lambda_pos");
    names__.emplace_back("lambda_neg");
    names__.emplace_back("psi_est");
    names__.emplace_back("z_trait");
    names__.emplace_back("L_trait");
    names__.emplace_back("z");
    names__.emplace_back("disp");
    names__.emplace_back("eta");
    names__.emplace_back("lambda");
    names__.emplace_back("psi");
    names__.emplace_back("r");
    names__.emplace_back("Cor_trait");
    } // get_param_names() 
    
  inline void get_dims(std::vector<std::vector<size_t>>& dimss__) const {
    dimss__.clear();
    dimss__.emplace_back(std::vector<size_t>{
                                             static_cast<size_t>(gamma_1dim__)});
    
    dimss__.emplace_back(std::vector<size_t>{
                                             static_cast<size_t>(gamma_ord_1dim__)
                                             ,
                                             static_cast<size_t>(gamma_ord_2dim__)
                                             });
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(N_item_pos)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(N_item_neg)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(N_item_est)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(N_trait),
                                             static_cast<size_t>(N_person)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(N_trait),
                                             static_cast<size_t>(N_trait)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(N_item)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(disp_1dim__)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(N_person),
                                             static_cast<size_t>(N_trait)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(N_item)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(N_item)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(N_item)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(N_trait),
                                             static_cast<size_t>(N_trait)});
    
    } // get_dims() 
    
  inline void constrained_param_names(
                                      std::vector<std::string>& param_names__,
                                      bool emit_transformed_parameters__ = true,
                                      bool emit_generated_quantities__ = true) const
    final {
    
    for (int sym1__ = 1; sym1__ <= gamma_1dim__; ++sym1__) {
      {
        param_names__.emplace_back(std::string() + "gamma" + '.' + std::to_string(sym1__));
      }}
    for (int sym1__ = 1; sym1__ <= gamma_ord_2dim__; ++sym1__) {
      {
        for (int sym2__ = 1; sym2__ <= gamma_ord_1dim__; ++sym2__) {
          {
            param_names__.emplace_back(std::string() + "gamma_ord" + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
          }}
      }}
    for (int sym1__ = 1; sym1__ <= N_item_pos; ++sym1__) {
      {
        param_names__.emplace_back(std::string() + "lambda_pos" + '.' + std::to_string(sym1__));
      }}
    for (int sym1__ = 1; sym1__ <= N_item_neg; ++sym1__) {
      {
        param_names__.emplace_back(std::string() + "lambda_neg" + '.' + std::to_string(sym1__));
      }}
    for (int sym1__ = 1; sym1__ <= N_item_est; ++sym1__) {
      {
        param_names__.emplace_back(std::string() + "psi_est" + '.' + std::to_string(sym1__));
      }}
    for (int sym1__ = 1; sym1__ <= N_person; ++sym1__) {
      {
        for (int sym2__ = 1; sym2__ <= N_trait; ++sym2__) {
          {
            param_names__.emplace_back(std::string() + "z_trait" + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
          }}
      }}
    for (int sym1__ = 1; sym1__ <= N_trait; ++sym1__) {
      {
        for (int sym2__ = 1; sym2__ <= N_trait; ++sym2__) {
          {
            param_names__.emplace_back(std::string() + "L_trait" + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
          }}
      }}
    for (int sym1__ = 1; sym1__ <= N_item; ++sym1__) {
      {
        param_names__.emplace_back(std::string() + "z" + '.' + std::to_string(sym1__));
      }}
    for (int sym1__ = 1; sym1__ <= disp_1dim__; ++sym1__) {
      {
        param_names__.emplace_back(std::string() + "disp" + '.' + std::to_string(sym1__));
      }}
    if (emit_transformed_parameters__) {
      for (int sym1__ = 1; sym1__ <= N_trait; ++sym1__) {
        {
          for (int sym2__ = 1; sym2__ <= N_person; ++sym2__) {
            {
              param_names__.emplace_back(std::string() + "eta" + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
            }}
        }}
      for (int sym1__ = 1; sym1__ <= N_item; ++sym1__) {
        {
          param_names__.emplace_back(std::string() + "lambda" + '.' + std::to_string(sym1__));
        }}
      for (int sym1__ = 1; sym1__ <= N_item; ++sym1__) {
        {
          param_names__.emplace_back(std::string() + "psi" + '.' + std::to_string(sym1__));
        }}
      for (int sym1__ = 1; sym1__ <= N_item; ++sym1__) {
        {
          param_names__.emplace_back(std::string() + "r" + '.' + std::to_string(sym1__));
        }}
    }
    
    if (emit_generated_quantities__) {
      for (int sym1__ = 1; sym1__ <= N_trait; ++sym1__) {
        {
          for (int sym2__ = 1; sym2__ <= N_trait; ++sym2__) {
            {
              param_names__.emplace_back(std::string() + "Cor_trait" + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
            }}
        }}
    }
    
    } // constrained_param_names() 
    
  inline void unconstrained_param_names(
                                        std::vector<std::string>& param_names__,
                                        bool emit_transformed_parameters__ = true,
                                        bool emit_generated_quantities__ = true) const
    final {
    
    for (int sym1__ = 1; sym1__ <= gamma_1dim__; ++sym1__) {
      {
        param_names__.emplace_back(std::string() + "gamma" + '.' + std::to_string(sym1__));
      }}
    for (int sym1__ = 1; sym1__ <= gamma_ord_2dim__; ++sym1__) {
      {
        for (int sym2__ = 1; sym2__ <= gamma_ord_1dim__; ++sym2__) {
          {
            param_names__.emplace_back(std::string() + "gamma_ord" + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
          }}
      }}
    for (int sym1__ = 1; sym1__ <= N_item_pos; ++sym1__) {
      {
        param_names__.emplace_back(std::string() + "lambda_pos" + '.' + std::to_string(sym1__));
      }}
    for (int sym1__ = 1; sym1__ <= N_item_neg; ++sym1__) {
      {
        param_names__.emplace_back(std::string() + "lambda_neg" + '.' + std::to_string(sym1__));
      }}
    for (int sym1__ = 1; sym1__ <= N_item_est; ++sym1__) {
      {
        param_names__.emplace_back(std::string() + "psi_est" + '.' + std::to_string(sym1__));
      }}
    for (int sym1__ = 1; sym1__ <= N_person; ++sym1__) {
      {
        for (int sym2__ = 1; sym2__ <= N_trait; ++sym2__) {
          {
            param_names__.emplace_back(std::string() + "z_trait" + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
          }}
      }}
    for (int sym1__ = 1; sym1__ <= ((N_trait * (N_trait - 1)) / 2); ++sym1__) {
      {
        param_names__.emplace_back(std::string() + "L_trait" + '.' + std::to_string(sym1__));
      }}
    for (int sym1__ = 1; sym1__ <= N_item; ++sym1__) {
      {
        param_names__.emplace_back(std::string() + "z" + '.' + std::to_string(sym1__));
      }}
    for (int sym1__ = 1; sym1__ <= disp_1dim__; ++sym1__) {
      {
        param_names__.emplace_back(std::string() + "disp" + '.' + std::to_string(sym1__));
      }}
    if (emit_transformed_parameters__) {
      for (int sym1__ = 1; sym1__ <= N_trait; ++sym1__) {
        {
          for (int sym2__ = 1; sym2__ <= N_person; ++sym2__) {
            {
              param_names__.emplace_back(std::string() + "eta" + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
            }}
        }}
      for (int sym1__ = 1; sym1__ <= N_item; ++sym1__) {
        {
          param_names__.emplace_back(std::string() + "lambda" + '.' + std::to_string(sym1__));
        }}
      for (int sym1__ = 1; sym1__ <= N_item; ++sym1__) {
        {
          param_names__.emplace_back(std::string() + "psi" + '.' + std::to_string(sym1__));
        }}
      for (int sym1__ = 1; sym1__ <= N_item; ++sym1__) {
        {
          param_names__.emplace_back(std::string() + "r" + '.' + std::to_string(sym1__));
        }}
    }
    
    if (emit_generated_quantities__) {
      for (int sym1__ = 1; sym1__ <= ((N_trait * (N_trait - 1)) / 2);
           ++sym1__) {
        {
          param_names__.emplace_back(std::string() + "Cor_trait" + '.' + std::to_string(sym1__));
        }}
    }
    
    } // unconstrained_param_names() 
    
  inline std::string get_constrained_sizedtypes() const {
    stringstream s__;
    s__ << "[{\"name\":\"gamma\",\"type\":{\"name\":\"vector\",\"length\":" << gamma_1dim__ << "},\"block\":\"parameters\"},{\"name\":\"gamma_ord\",\"type\":{\"name\":\"array\",\"length\":" << gamma_ord_1dim__ << ",\"element_type\":{\"name\":\"vector\",\"length\":" << gamma_ord_2dim__ << "}},\"block\":\"parameters\"},{\"name\":\"lambda_pos\",\"type\":{\"name\":\"vector\",\"length\":" << N_item_pos << "},\"block\":\"parameters\"},{\"name\":\"lambda_neg\",\"type\":{\"name\":\"vector\",\"length\":" << N_item_neg << "},\"block\":\"parameters\"},{\"name\":\"psi_est\",\"type\":{\"name\":\"vector\",\"length\":" << N_item_est << "},\"block\":\"parameters\"},{\"name\":\"z_trait\",\"type\":{\"name\":\"matrix\",\"rows\":" << N_trait << ",\"cols\":" << N_person << "},\"block\":\"parameters\"},{\"name\":\"L_trait\",\"type\":{\"name\":\"matrix\",\"rows\":" << N_trait << ",\"cols\":" << N_trait << "},\"block\":\"parameters\"},{\"name\":\"z\",\"type\":{\"name\":\"vector\",\"length\":" << N_item << "},\"block\":\"parameters\"},{\"name\":\"disp\",\"type\":{\"name\":\"vector\",\"length\":" << disp_1dim__ << "},\"block\":\"parameters\"},{\"name\":\"eta\",\"type\":{\"name\":\"matrix\",\"rows\":" << N_person << ",\"cols\":" << N_trait << "},\"block\":\"transformed_parameters\"},{\"name\":\"lambda\",\"type\":{\"name\":\"vector\",\"length\":" << N_item << "},\"block\":\"transformed_parameters\"},{\"name\":\"psi\",\"type\":{\"name\":\"vector\",\"length\":" << N_item << "},\"block\":\"transformed_parameters\"},{\"name\":\"r\",\"type\":{\"name\":\"vector\",\"length\":" << N_item << "},\"block\":\"transformed_parameters\"},{\"name\":\"Cor_trait\",\"type\":{\"name\":\"matrix\",\"rows\":" << N_trait << ",\"cols\":" << N_trait << "},\"block\":\"generated_quantities\"}]";
    return s__.str();
    } // get_constrained_sizedtypes() 
    
  inline std::string get_unconstrained_sizedtypes() const {
    stringstream s__;
    s__ << "[{\"name\":\"gamma\",\"type\":{\"name\":\"vector\",\"length\":" << gamma_1dim__ << "},\"block\":\"parameters\"},{\"name\":\"gamma_ord\",\"type\":{\"name\":\"array\",\"length\":" << gamma_ord_1dim__ << ",\"element_type\":{\"name\":\"vector\",\"length\":" << gamma_ord_2dim__ << "}},\"block\":\"parameters\"},{\"name\":\"lambda_pos\",\"type\":{\"name\":\"vector\",\"length\":" << N_item_pos << "},\"block\":\"parameters\"},{\"name\":\"lambda_neg\",\"type\":{\"name\":\"vector\",\"length\":" << N_item_neg << "},\"block\":\"parameters\"},{\"name\":\"psi_est\",\"type\":{\"name\":\"vector\",\"length\":" << N_item_est << "},\"block\":\"parameters\"},{\"name\":\"z_trait\",\"type\":{\"name\":\"matrix\",\"rows\":" << N_trait << ",\"cols\":" << N_person << "},\"block\":\"parameters\"},{\"name\":\"L_trait\",\"type\":{\"name\":\"vector\",\"length\":" << ((N_trait * (N_trait - 1)) / 2) << "},\"block\":\"parameters\"},{\"name\":\"z\",\"type\":{\"name\":\"vector\",\"length\":" << N_item << "},\"block\":\"parameters\"},{\"name\":\"disp\",\"type\":{\"name\":\"vector\",\"length\":" << disp_1dim__ << "},\"block\":\"parameters\"},{\"name\":\"eta\",\"type\":{\"name\":\"matrix\",\"rows\":" << N_person << ",\"cols\":" << N_trait << "},\"block\":\"transformed_parameters\"},{\"name\":\"lambda\",\"type\":{\"name\":\"vector\",\"length\":" << N_item << "},\"block\":\"transformed_parameters\"},{\"name\":\"psi\",\"type\":{\"name\":\"vector\",\"length\":" << N_item << "},\"block\":\"transformed_parameters\"},{\"name\":\"r\",\"type\":{\"name\":\"vector\",\"length\":" << N_item << "},\"block\":\"transformed_parameters\"},{\"name\":\"Cor_trait\",\"type\":{\"name\":\"vector\",\"length\":" << ((N_trait * (N_trait - 1)) / 2) << "},\"block\":\"generated_quantities\"}]";
    return s__.str();
    } // get_unconstrained_sizedtypes() 
    
  
    // Begin method overload boilerplate
    template <typename RNG>
    inline void write_array(RNG& base_rng,
                            Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                            Eigen::Matrix<double,Eigen::Dynamic,1>& vars,
                            const bool emit_transformed_parameters = true,
                            const bool emit_generated_quantities = true,
                            std::ostream* pstream = nullptr) const {
      std::vector<double> vars_vec(vars.size());
      std::vector<int> params_i;
      write_array_impl(base_rng, params_r, params_i, vars_vec,
          emit_transformed_parameters, emit_generated_quantities, pstream);
      vars.resize(vars_vec.size());
      for (int i = 0; i < vars.size(); ++i) {
        vars.coeffRef(i) = vars_vec[i];
      }
    }
    template <typename RNG>
    inline void write_array(RNG& base_rng, std::vector<double>& params_r,
                            std::vector<int>& params_i,
                            std::vector<double>& vars,
                            bool emit_transformed_parameters = true,
                            bool emit_generated_quantities = true,
                            std::ostream* pstream = nullptr) const {
      write_array_impl(base_rng, params_r, params_i, vars, emit_transformed_parameters, emit_generated_quantities, pstream);
    }
    template <bool propto__, bool jacobian__, typename T_>
    inline T_ log_prob(Eigen::Matrix<T_,Eigen::Dynamic,1>& params_r,
                       std::ostream* pstream = nullptr) const {
      Eigen::Matrix<int, -1, 1> params_i;
      return log_prob_impl<propto__, jacobian__>(params_r, params_i, pstream);
    }
    template <bool propto__, bool jacobian__, typename T__>
    inline T__ log_prob(std::vector<T__>& params_r,
                        std::vector<int>& params_i,
                        std::ostream* pstream = nullptr) const {
      return log_prob_impl<propto__, jacobian__>(params_r, params_i, pstream);
    }
  
    inline void transform_inits(const stan::io::var_context& context,
                         Eigen::Matrix<double, Eigen::Dynamic, 1>& params_r,
                         std::ostream* pstream = nullptr) const final {
      std::vector<double> params_r_vec(params_r.size());
      std::vector<int> params_i;
      transform_inits_impl(context, params_i, params_r_vec, pstream);
      params_r.resize(params_r_vec.size());
      for (int i = 0; i < params_r.size(); ++i) {
        params_r.coeffRef(i) = params_r_vec[i];
      }
    }
    inline void transform_inits(const stan::io::var_context& context,
                                std::vector<int>& params_i,
                                std::vector<double>& vars,
                                std::ostream* pstream = nullptr) const final {
      transform_inits_impl(context, params_i, vars, pstream);
    }        
};
}
using stan_model = model_thurstonian_irt_model_namespace::model_thurstonian_irt_model;
#ifndef USING_R
// Boilerplate
stan::model::model_base& new_model(
        stan::io::var_context& data_context,
        unsigned int seed,
        std::ostream* msg_stream) {
  stan_model* m = new stan_model(data_context, seed, msg_stream);
  return *m;
}
stan::math::profile_map& get_stan_profile_data() {
  return model_thurstonian_irt_model_namespace::profiles__;
}
#endif
#endif
