% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extract-regression-residuals.R
\name{extract_regression_residuals}
\alias{extract_regression_residuals}
\title{Extract Residuals from Fast Regression Models}
\usage{
extract_regression_residuals(.model_tbl, .pivot_long = FALSE)
}
\arguments{
\item{.model_tbl}{A fast regression model specification table (\code{fst_reg_spec_tbl}).}

\item{.pivot_long}{A logical value indicating if the output should be pivoted.
The default is \code{FALSE}.}
}
\value{
The function returns a list of data frames, each containing residuals,
actual values, and predicted values for a specific model.
}
\description{
This function extracts residuals from a fast regression model
table (\code{fast_regression()}).
}
\details{
The function checks if the input model specification table inherits the class
'fst_reg_spec_tbl' and if it contains the column 'pred_wflw'. It then
manipulates the data, grouping it by model, and extracts residuals for each model.
The result is a list of data frames, each containing residuals, actual values,
and predicted values for a specific model.
}
\examples{
library(recipes, quietly = TRUE)

rec_obj <- recipe(mpg ~ ., data = mtcars)

fr_tbl <- fast_regression(mtcars, rec_obj, .parsnip_eng = c("lm","glm"),
.parsnip_fns = "linear_reg")

extract_regression_residuals(fr_tbl)
extract_regression_residuals(fr_tbl, .pivot_long = TRUE)

}
\seealso{
Other Extractor: 
\code{\link{extract_model_spec}()},
\code{\link{extract_wflw_fit}()},
\code{\link{extract_wflw_pred}()},
\code{\link{extract_wflw}()},
\code{\link{get_model}()}
}
\author{
Steven P. Sanderson II, MPH
}
\concept{Extractor}
