% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers_bf_tests.R
\name{bf_expr}
\alias{bf_expr}
\title{Prepare caption with expression for Bayes Factor results}
\usage{
bf_expr(
  bf.object,
  k = 2L,
  conf.level = 0.95,
  conf.method = "hdi",
  centrality = "median",
  output = "null",
  caption = NULL,
  anova.design = FALSE,
  ...
)
}
\arguments{
\item{bf.object}{An object from \code{BayesFactor} package.}

\item{k}{Number of digits after decimal point (should be an integer)
(Default: \code{k = 2L}).}

\item{conf.level}{Value or vector of probability of the CI (between 0 and 1)
to be estimated. Default to \code{0.95} (95\%).}

\item{conf.method}{The type of index used for Credible Interval. Can be
\code{"hdi"} (default, see \code{\link[bayestestR:hdi]{bayestestR::hdi()}}), \code{"eti"} (see
\code{\link[bayestestR:eti]{bayestestR::eti()}}) or \code{"si"} (see \code{\link[bayestestR:si]{bayestestR::si()}}).}

\item{centrality}{The point-estimates (centrality indices) to compute.
Character (vector) or list with one or more of these options: \code{"median"},
\code{"mean"}, \code{"MAP"} or \code{"all"}.}

\item{output}{Can either be \code{"null"} (or \code{"caption"} or \code{"H0"} or \code{"h0"}),
which will return expression with evidence in favor of the null hypothesis,
or \code{"alternative"} (or \code{"title"} or \code{"H1"} or \code{"h1"}), which will return
expression with evidence in favor of the alternative hypothesis, or
\code{"results"}, which will return a dataframe with results all the details).}

\item{caption}{Text to display as caption (will be displayed on top of the
Bayes Factor caption/message).}

\item{anova.design}{Whether the object is from \code{BayesFactor::anovaBF}
(default: \code{FALSE}). The expression is different for anova designs because
not all details are available.}

\item{...}{Additional arguments passed to
\code{\link[parameters:model_parameters.BFBayesFactor]{parameters::model_parameters.BFBayesFactor()}}.}
}
\description{
Convenience function to create an expression with Bayes
Factor results.
}
\examples{
\donttest{
# for reproducibility
set.seed(123)
library(tidyBF)

# creating caption (for null)
bf_expr(
  BayesFactor::correlationBF(
    x = iris$Sepal.Length,
    y = iris$Petal.Length
  ),
  output = "null",
  k = 3,
  caption = "Note: Iris dataset"
)
}
}
