% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bf_ttest.R
\name{bf_ttest}
\alias{bf_ttest}
\title{Bayes Factor for \emph{t}-test}
\usage{
bf_ttest(
  data,
  x,
  y = NULL,
  subject.id = NULL,
  paired = FALSE,
  test.value = 0,
  bf.prior = 0.707,
  ...
)
}
\arguments{
\item{data}{A dataframe (or a tibble) from which variables specified are to
be taken. A matrix or tables will \strong{not} be accepted.}

\item{x}{Either the grouping variable from the dataframe \code{data} if it's a
two-sample \emph{t}-test or a numeric variable if it's a one-sample \emph{t}-test.}

\item{y}{The column in \code{data} containing the response (outcome) variable to
be plotted on the \code{y}-axis. Can be entered either as a character string
(e.g., \code{"y"}) or as a bare expression (e.g, \code{y}).}

\item{subject.id}{In case of repeated measures design (\code{paired = TRUE},
i.e.), this argument specifies the subject or repeated measures id. Note
that if this argument is \code{NULL} (which is the default), the function
assumes that the data has already been sorted by such an id by the user and
creates an internal identifier. So if your data is \strong{not} sorted and you
leave this argument unspecified, the results can be inaccurate.}

\item{paired}{Decides whether the design is repeated measures or not
(Default: \code{FALSE}).}

\item{test.value}{A number specifying the value of the null hypothesis
(Default: \code{0}).}

\item{bf.prior}{A number between \code{0.5} and \code{2} (default \code{0.707}), the prior
width to use in calculating Bayes factors.}

\item{...}{
  Arguments passed on to \code{\link[=bf_extractor]{bf_extractor}}
  \describe{
    \item{\code{conf.level}}{Confidence/Credible Interval (CI) level. Default to \code{0.95}
(\verb{95\%}).}
    \item{\code{centrality}}{The point-estimates (centrality indices) to compute.
Character (vector) or list with one or more of these options: \code{"median"},
\code{"mean"}, \code{"MAP"} or \code{"all"}.}
    \item{\code{conf.method}}{The type of index used for Credible Interval. Can be
\code{"hdi"} (default, see \code{\link[bayestestR:hdi]{bayestestR::hdi()}}), \code{"eti"} (see
\code{\link[bayestestR:eti]{bayestestR::eti()}}) or \code{"si"} (see \code{\link[bayestestR:si]{bayestestR::si()}}).}
    \item{\code{k}}{Number of digits after decimal point (should be an integer)
(Default: \code{k = 2L}).}
    \item{\code{top.text}}{Text to display as top.text (will be displayed on top of the
Bayes Factor top.text/message).}
    \item{\code{output}}{If \code{"expression"}, will return expression with statistical
details, while \code{"dataframe"} will return a dataframe containing the
results.}
  }}
}
\description{
Bayes Factor for \emph{t}-test
}
\details{
If \code{y} is \code{NULL}, a one-sample \emph{t}-test will be carried out,
otherwise a two-sample \emph{t}-test will be carried out.
}
\examples{

# ------------------- two-samples tests -----------------------------------

# for reproducibility
set.seed(123)
library(tidyBF)

# to get dataframe (between-subjects)
bf_ttest(
  data = mtcars,
  x = am,
  y = wt,
  paired = FALSE,
  bf.prior = 0.880,
  output = "dataframe"
)

# to get expression (within-subjects)
bf_ttest(
  data = dplyr::filter(bugs_long, condition \%in\% c("LDLF", "LDHF")),
  x = condition,
  y = desire,
  subject.id = subject,
  paired = TRUE,
  bf.prior = 0.880,
  output = "dataframe"
)

# ------------------- one-samples test -----------------------------------

# to get expression
bf_ttest(
  data = iris,
  x = Sepal.Length,
  test.value = 5.85,
  output = "expression"
)
}
\seealso{
\code{\link{bf_contingency_tab}}, \code{\link{bf_corr_test}},
\code{\link{bf_oneway_anova}}
}
