% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/theme_tidybde.R
\name{theme_tidybde}
\alias{theme_tidybde}
\title{BdE \code{ggplot2} theme}
\usage{
theme_tidybde(...)
}
\arguments{
\item{...}{
  Arguments passed on to \code{\link[ggplot2:ggtheme]{ggplot2::theme_classic}}
  \describe{
    \item{\code{base_size}}{base font size, given in pts.}
    \item{\code{base_family}}{base font family}
    \item{\code{base_line_size}}{base size for line elements}
    \item{\code{base_rect_size}}{base size for rect elements}
  }}
}
\value{
A \code{\link[ggplot2:ggtheme]{ggplot2::theme_classic()}}.
}
\description{
A custom \CRANpkg{ggplot2} theme based on the publications of BdE.
}
\details{
Theme based on \code{\link[ggplot2:ggtheme]{ggplot2::theme_classic()}}.
}
\examples{
\dontshow{if (bde_check_access()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
\donttest{
library(ggplot2)
library(dplyr)
library(tidyr)

series_TC <- bde_series_full_load("TC_1_1.csv")

# If download was OK then plot
if (nrow(series_TC) > 0) {
  series_TC <- series_TC[c(1, 2)]

  series_TC_pivot <- series_TC \%>\%
    filter(
      Date >= "2020-01-01" & Date <= "2020-12-31",
      !is.na(series_TC[[2]])
    )

  names(series_TC_pivot) <- c("x", "y")

  ggplot(series_TC_pivot, aes(x = x, y = y)) +
    geom_line(linewidth = 0.8, color = bde_tidy_palettes(n = 1)) +
    labs(
      title = "Title",
      subtitle = "Some metric",
      caption = "Bank of Spain"
    ) +
    theme_tidybde()
}
}
\dontshow{\}) # examplesIf}
}
\seealso{
\code{\link[ggplot2:ggtheme]{ggplot2::theme_classic()}}

Other bde_plot: 
\code{\link{bde_tidy_palettes}()},
\code{\link{scales_bde}}
}
\concept{bde_plot}
