% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_profiles.R
\name{plot_profiles}
\alias{plot_profiles}
\title{Plot variable means and variances by profile}
\usage{
plot_profiles(x, to_center = F, to_scale = F, plot_what = "tibble",
  plot_error_bars = TRUE, plot_rawdata = TRUE, ci = 0.95)
}
\arguments{
\item{x}{output from estimate_profiles()}

\item{to_center}{whether to center the data before plotting}

\item{to_scale}{whether to scale the data before plotting}

\item{plot_what}{whether to plot tibble or mclust output from estimate_profiles(); defaults to tibble}

\item{plot_error_bars}{whether to plot error bars (representing the 95 percent confidence interval for the mean of each variable)}

\item{plot_rawdata}{whether to plot raw data; defaults to TRUE}

\item{ci}{confidence interval to plot (defaults to 0.95)}
}
\description{
Plot variable means and variances by profile
}
\details{
Plot the variable means and variances for data frame output from estimate_profiles()

Plot the variable means and variances for data frame output from estimate_profiles().
When plot_what is set to 'mclust', the errorbars represent non-parametric
confidence intervals, obtained using bootstrapping (100 samples). Note that
100 samples might be adequate for plotting, but is low for inference. If the
number of participants per class is highly unbalanced, then weighted likelihood
bootstrapping is used to ensure that each case is represented in the bootstrap
samples (see O'Hagan, Murphy, Scrucca, and Gormley, 2015).
}
\examples{
m3 <- estimate_profiles(iris,
    Sepal.Length, Sepal.Width, Petal.Length, Petal.Width,
    n_profiles = 3)
plot_profiles(m3)

m3 <- estimate_profiles(iris,
    Sepal.Length, Sepal.Width, Petal.Length, Petal.Width,
    n_profiles = 3, to_return = "mclust")
plot_profiles(m3, plot_what = "mclust")
}
