% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_functions.R
\name{calc_lrt}
\alias{calc_lrt}
\title{Lo-Mendell-Rubin likelihood ratio test}
\usage{
calc_lrt(n, null_ll, null_param, null_classes, alt_ll, alt_param, alt_classes)
}
\arguments{
\item{n}{Integer. Sample size}

\item{null_ll}{Numeric. Log-likelihood of the null model.}

\item{null_param}{Integer. Number of parameters of the null model.}

\item{null_classes}{Integer. Number of classes of the null model.}

\item{alt_ll}{Numeric. Log-likelihood of the alternative model.}

\item{alt_param}{Integer. Number of parameters of the alternative model.}

\item{alt_classes}{Integer. Number of classes of the alternative model.}
}
\value{
A numeric vector containing the likelihood ratio LR, the ad-hoc
corrected LMR, degrees of freedom, and the LMR p-value.
}
\description{
Implements the ad-hoc adjusted likelihood ratio test (LRT)
described in Formula 15 of Lo, Mendell, & Rubin (2001), or LMR LRT.
}
\examples{
calc_lrt(150L, -741.02, 8, 1, -488.91, 13, 2)
}
\references{
Lo Y, Mendell NR, Rubin DB. Testing the number of components in a
normal mixture. Biometrika. 2001;88(3):767–778. doi:10.1093/biomet/88.3.767
}
