% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot-plot_sem.R
\name{get_edges}
\alias{get_edges}
\title{Extract edges from a SEM model object}
\usage{
get_edges(x, label = "est_sig", ...)
}
\arguments{
\item{x}{A model object of class \code{mplusObject} or \code{lavaan}.}

\item{label}{Character, indicating which column to use for edge labels.
Defaults to 'est_sig', which consists of the estimate value with significance
asterisks.}

\item{...}{Additional parameters to be passed to and from other functions.}
}
\value{
An object of class 'tidy_edges'
}
\description{
Attempts to extract edges from a SEM model object, where edges
are defined as regression paths and covariances between variables (nodes).
}
\examples{
library(lavaan)
res <- sem("dist ~ speed", cars)
get_edges(res)
}
\keyword{tidy_graph}
