% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mixture-3step.R
\name{BCH}
\alias{BCH}
\title{Estimate an Auxiliary Model using the BCH Method}
\usage{
BCH(x, model, data, ...)
}
\arguments{
\item{x}{An object for which a method exists.}

\item{model}{An object that can be converted to an \code{OpenMx} model
using \code{\link{as_ram}}.}

\item{data}{A data.frame on which the auxiliary model can be evaluated.}

\item{...}{further arguments to be passed to or from other methods.}
}
\value{
An MxModel.
}
\description{
Estimate an auxiliary model based on a latent classification
by means of mixture modeling (see \code{\link{mx_mixture}}).

The auxiliary model is treated as a multi-group model. All cases are used in
all groups, but they are weighted by group-specific BCH weights as described
in Bolck, Croon, & Hagenaars, 2004.
}
\examples{
dat <- data.frame(x = iris$Petal.Length)
mixmod <- mx_profiles(dat,
                      classes = 2)
res <- BCH(mixmod, "y ~ 1", data = data.frame(y = iris$Sepal.Length))
}
\references{
Bolck, A., Croon, M., & Hagenaars, J. (2004). Estimating latent
structure models with categorical variables: One-step versus three-step
estimators. Political Analysis, 12(1), 3–27. <doi:10.2307/25791751>
}
