% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/motley_functions.R
\name{chisq_sb}
\alias{chisq_sb}
\title{Satorra-Bentler corrected chi-square test}
\usage{
chisq_sb(chisq1, df1, scf1 = 1, chisq2, df2, scf2 = 1)
}
\arguments{
\item{chisq1}{An object for which a method exists; e.g., a chi-square value,
or a \code{data.frame}.}

\item{df1}{Degrees of freedom of model 1.}

\item{scf1}{Scale correction factor of model 1.}

\item{chisq2}{Chi square value of model 2.}

\item{df2}{Degrees of freedom of model 2.}

\item{scf2}{Scale correction factor of model 2.}
}
\value{
Chi-square difference value with corresponding degrees of freedom and
p-value.
}
\description{
Computes Satorra-Bentler corrected chi-square test.
}
\details{
Reference:
Satorra, A., & Bentler, P. M. (2001). A scaled difference chi-square test
statistic for moment structure analysis. Psychometrika, 66(4), 507-514.
<doi:10.1007/BF02296192>
}
\examples{
df <- data.frame(chi2 = c(23, 44, 65), df = c(78, 74, 70), scf = c(1.02, 1.12, 1.28))
chisq_sb(24, 78, 1.02, 65, 70, 1.28)
}
\author{
Caspar J. van Lissa
}
\keyword{internal}
