% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plas_depression.R
\docType{data}
\name{plas_depression}
\alias{plas_depression}
\title{Simulated depression data}
\format{
A data frame with 978 rows and 6 variables.
}
\usage{
data(plas_depression)
}
\description{
This simulated dataset, based on work
in progress by Plas and colleagues,
contains six repeated measurements
of the Depression subscale of the
Symptom Checklist-90 (SCL-90).
}
\details{
These data are inspired by the
\emph{Prospection in Stress-related Military Research (PRISMO)} study,
which examined of psychological problems
after deployment in more than 1,000 Dutch
military personnel who were deployed to Afghanistan, from 2005-2019.

\tabular{lll}{
\strong{scl.1} \tab \code{integer} \tab Sum score of SCL90 depression pre-deployment\cr
\strong{scl.2} \tab \code{integer} \tab Sum score of SCL90 depression 1 month post-deployment\cr
\strong{scl.3} \tab \code{integer} \tab Sum score of SCL90 depression 6 months post-deployment\cr
\strong{scl.4} \tab \code{integer} \tab Sum score of SCL90 depression 1 year post-deployment\cr
\strong{scl.5} \tab \code{integer} \tab Sum score of SCL90 depression 2 years post-deployment\cr
\strong{scl.6} \tab \code{integer} \tab Sum score of SCL90 depression 10 years post-deployment
}
}
\references{
van der Wal, S. J., Gorter, R., Reijnen, A., Geuze, E., & Vermetten, E. (2019). Cohort profile: The Prospective Research In Stress-Related Military Operations (PRISMO) study in the Dutch Armed Forces. BMJ Open, 9(3), e026670.
\doi{10.1136/bmjopen-2018-026670}
}
\keyword{datasets}
