% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/point_interval.R
\name{point_interval}
\alias{point_interval}
\alias{point_interval.default}
\alias{point_interval.numeric}
\alias{point_intervalh}
\alias{qi}
\alias{hdi}
\alias{Mode}
\alias{hdci}
\alias{mean_qi}
\alias{mean_qih}
\alias{median_qi}
\alias{median_qih}
\alias{mode_qi}
\alias{mode_qih}
\alias{mean_hdi}
\alias{mean_hdih}
\alias{median_hdi}
\alias{median_hdih}
\alias{mode_hdi}
\alias{mode_hdih}
\alias{mean_hdci}
\alias{mean_hdcih}
\alias{median_hdci}
\alias{median_hdcih}
\alias{mode_hdci}
\alias{mode_hdcih}
\title{Point and interval summaries for tidy data frames of draws from distributions}
\usage{
point_interval(.data, ..., .width = 0.95, .point = median,
  .interval = qi, .simple_names = TRUE, na.rm = FALSE,
  .exclude = c(".chain", ".iteration", ".draw", ".row"), .prob)

\method{point_interval}{default}(.data, ..., .width = 0.95,
  .point = median, .interval = qi, .simple_names = TRUE,
  na.rm = FALSE, .exclude = c(".chain", ".iteration", ".draw", ".row"),
  .prob)

\method{point_interval}{numeric}(.data, ..., .width = 0.95,
  .point = median, .interval = qi, .simple_names = FALSE,
  na.rm = FALSE, .exclude = c(".chain", ".iteration", ".draw", ".row"),
  .prob)

point_intervalh(...)

qi(x, .width = 0.95, .prob, na.rm = FALSE)

hdi(x, .width = 0.95, .prob, na.rm = FALSE)

Mode(x, na.rm = FALSE)

hdci(x, .width = 0.95, na.rm = FALSE)

mean_qi(.data, ..., .width = 0.95)

mean_qih(...)

median_qi(.data, ..., .width = 0.95)

median_qih(...)

mode_qi(.data, ..., .width = 0.95)

mode_qih(...)

mean_hdi(.data, ..., .width = 0.95)

mean_hdih(...)

median_hdi(.data, ..., .width = 0.95)

median_hdih(...)

mode_hdi(.data, ..., .width = 0.95)

mode_hdih(...)

mean_hdci(.data, ..., .width = 0.95)

mean_hdcih(...)

median_hdci(.data, ..., .width = 0.95)

median_hdcih(...)

mode_hdci(.data, ..., .width = 0.95)

mode_hdcih(...)
}
\arguments{
\item{.data}{Data frame (or grouped data frame as returned by \code{\link{group_by}})
that contains draws to summarize.}

\item{...}{Bare column names or expressions that, when evaluated in the context of
\code{.data}, represent draws to summarize. If this is empty, then by default all
columns that are not group columns and which are not in \code{.exclude} (by default
\code{".chain"}, \code{".iteration"}, \code{".draw"}, and \code{".row"}) will be summarized.
This can be list columns.}

\item{.width}{vector of probabilities to use that determine the widths of the resulting intervals.
If multiple probabilities are provided, multiple rows per group are generated, each with
a different probability interval (and value of the corresponding \code{.width} column).}

\item{.point}{Point summary function, which takes a vector and returns a single
value, e.g. \code{\link{mean}}, \code{\link{median}}, or \code{\link{Mode}}.}

\item{.interval}{Interval function, which takes a vector and a probability
(\code{.width}) and returns a two-element vector representing the lower and upper
bound of an interval; e.g. \code{\link{qi}}, \code{\link{hdi}}}

\item{.simple_names}{When \code{TRUE} and only a single column / vector is to be summarized, use the
name \code{.lower} for the lower end of the interval and \code{.upper} for the
upper end. If \code{.data} is a vector and this is \code{TRUE}, this will also set the column name
of the point summary to \code{.value}. When \code{FALSE} and \code{.data} is a data frame,
names the lower and upper intervals for each column \code{x} \code{x.lower} and \code{x.upper}.
When \code{FALSE} and \code{.data} is a vector, uses the naming scheme \code{y}, \code{ymin}
and \code{ymax} (for use with ggplot).}

\item{na.rm}{logical value indicating whether \code{NA} values should be stripped before the computation proceeds.
If \code{FALSE} (the default), any vectors to be summarised that contain \code{NA} will result in
point and interval summaries equal to \code{NA}.}

\item{.exclude}{A character vector of names of columns to be excluded from summarization
if no column names are specified to be summarized. Default ignores several meta-data column
names used in tidybayes.}

\item{.prob}{Deprecated. Use \code{.width} instead.}

\item{x}{vector to summarize (for interval functions: \code{qi} and \code{hdi})}
}
\description{
Translates draws from distributions in a (possibly grouped) data frame into point and
interval summaries (or set of point and interval summaries, if there are
multiple groups in a grouped data frame).
}
\details{
If \code{.data} is a data frame, then \code{...} is a list of bare names of
columns (or expressions derived from columns) of \code{.data}, on which
the point and interval summaries are derived. Column expressions are processed
using the tidy evaluation framework (see \code{\link[rlang]{eval_tidy}}).

For a column named \code{x}, the resulting data frame will have a column
named \code{x} containing its point summary. If there is a single
column to be summarized and \code{.simple_names} is \code{TRUE}, the output will
also contain columns \code{.lower} (the lower end of the interval),
\code{.upper} (the upper end of the interval).
Otherwise, for every summarized column \code{x}, the output will contain
\code{x.lower} (the lower end of the interval) and \code{x.upper} (the upper
end of the interval). Finally, the output will have a \code{.width} column
containing the' probability for the interval on each output row.

If \code{.data} includes groups (see e.g. \code{\link[dplyr]{group_by}}),
the points and intervals are calculated within the groups.

If \code{.data} is a vector, \code{...} is ignored and the result is a
data frame with one row per value of \code{.width} and three columns:
\code{y} (the point summary), \code{ymin} (the lower end of the interval),
\code{ymax} (the upper end of the interval), and \code{.width}, the probability
corresponding to the interval. This behavior allows \code{point_interval}
and its derived functions (like \code{median_qi}, \code{mean_qi}, \code{mode_hdi}, etc)
to be easily used to plot intervals in ggplot using methods like
\code{\link{geom_eye}}, \code{\link{geom_eyeh}}, or \code{\link{stat_summary}}.

The functions ending in \code{h} (e.g., \code{point_intervalh}, \code{median_qih})
behave identically to the function without the h, except that when passed a vector,
they return a data frame with \code{x}/\code{xmin}/\code{xmax} instead of
\code{y}/\code{ymin}/\code{ymax}. This allows them to be used as values of the
\code{fun.data = } argument of \code{stat_summaryh}. \strong{Note:} these
functions are not necessary if you use the \code{point_interval}
argument of \code{stat}s and \code{geom}s in the \code{tidybayes} package (e.g.
\code{\link{stat_pointintervalh}}, \code{\link{geom_halfeyeh}}, etc), as
these automatically adjust the function output to match their required aesthetics.

\code{median_qi}, \code{mode_hdi}, etc are short forms for
\code{point_interval(..., .point = median, .interval = qi)}, etc.

\code{qi} yields the quantile interval (also known as the percentile interval or
equi-tailed interval) as a 1x2 matrix.

\code{hdi} yields the highest-density interval(s) (also known as the highest posterior
density interval). \strong{Note:} If the distribution is multimodal, \code{hdi} may return multiple
intervals for each probability level (these will be spread over rows). You may wish to use
\code{hdci} (below) instead if you want a single highest-density interval, with the caveat that when
the distribution is multimodal \code{hdci} is not a highest-density interval. Internally \code{hdi} uses
\code{\link[HDInterval]{hdi}} with \code{allowSplit = TRUE} (when multimodal) and with
\code{allowSplit = FALSE} (when not multimodal).

\code{hdci} yields the highest-density \emph{continuous} interval. \strong{Note:} If the distribution
is multimodal, this may not actually be the highest-density interval (there may be a higher-density
discontinuous interval). Internally \code{hdci} uses
\code{\link[HDInterval]{hdi}} with \code{allowSplit = FALSE}; see that function for more
information on multimodality and continuous versus discontinuous intervals.
}
\examples{

library(dplyr)
library(ggplot2)

set.seed(123)

rnorm(1000) \%>\%
  median_qi()

data.frame(x = rnorm(1000)) \%>\%
  median_qi(x, .width = c(.50, .80, .95))

data.frame(
    x = rnorm(1000),
    y = rnorm(1000, mean = 2, sd = 2)
  ) \%>\%
  median_qi(x, y)

data.frame(
    x = rnorm(1000),
    group = "a"
  ) \%>\%
  rbind(data.frame(
    x = rnorm(1000, mean = 2, sd = 2),
    group = "b")
  ) \%>\%
  group_by(group) \%>\%
  median_qi(.width = c(.50, .80, .95))

multimodal_draws = data.frame(
    x = c(rnorm(5000, 0, 1), rnorm(2500, 4, 1))
  )

multimodal_draws \%>\%
  mode_hdi(.width = c(.66, .95))

multimodal_draws \%>\%
  ggplot(aes(x = x, y = 0)) +
  geom_halfeyeh(fun.data = mode_hdih, .width = c(.66, .95))

}
\author{
Matthew Kay
}
