% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geom_interval.R, R/geom_intervalh.R
\name{geom_interval}
\alias{geom_interval}
\alias{geom_intervalh}
\title{Multiple probability interval plots (ggplot geom)}
\usage{
geom_interval(mapping = NULL, data = NULL, stat = "identity",
  position = "identity", ..., na.rm = FALSE, show.legend = NA,
  inherit.aes = TRUE)

geom_intervalh(mapping = NULL, data = NULL, stat = "identity",
  position = "identity", ..., na.rm = FALSE, show.legend = NA,
  inherit.aes = TRUE)
}
\arguments{
\item{mapping}{The aesthetic mapping, usually constructed with
\code{\link{aes}} or \code{\link{aes_string}}. Only needs to be set at the
layer level if you are overriding the plot defaults.}

\item{data}{A layer specific dataset - only needed if you want to override
the plot defaults.}

\item{stat}{The statistical transformation to use on the data for this layer.}

\item{position}{The position adjustment to use for overlapping points on this layer.}

\item{...}{Other arguments passed to \code{\link{layer}}.}

\item{na.rm}{If \code{FALSE}, the default, missing values are removed with a warning. If \code{TRUE}, missing
values are silently removed.}

\item{show.legend}{Should this layer be included in the legends? \code{NA}, the default, includes if any aesthetics
are mapped. \code{FALSE} never includes, and \code{TRUE} always includes.}

\item{inherit.aes}{If \code{FALSE}, overrides the default aesthetics, rather than combining with them. This is
most useful for helper functions that define both data and aesthetics and shouldn't inherit behavior from the
default plot specification, e.g. borders.}
}
\description{
Modified versions of \code{\link{geom_linerange}} and \code{\link{geom_linerangeh}} with default aesthetics
designed for use with output from \code{\link{point_interval}}.
}
\details{
\code{geom_interval} is a modified version of \code{\link{geom_linerange}}, and \code{geom_intervalh} is
a modified version of \code{\link{geom_linerangeh}}. These geoms set some default aesthetics equal
to the \code{.lower}, \code{.upper}, and \code{.width} columns generated by the \code{point_interval} family
of functions, making them often more convenient than vanilla \code{\link{geom_linerange}} or
\code{\link{geom_linerangeh}} when used with functions like \code{\link{median_qi}}, \code{\link{mean_qi}},
\code{\link{mode_hdi}}, etc.

Specifically, \code{geom_interval} acts as if its default aesthetics are
\code{aes(ymin = .lower, ymax = .upper, color = fct_rev(ordered(.width)))}. \code{geom_intervalh} acts as if
its default aesthetics are \code{aes(xmin = .lower, xmax = .upper, color = fct_rev(ordered(.width)))}.
}
\examples{

library(magrittr)
library(ggplot2)

data(RankCorr, package = "tidybayes")

RankCorr \%>\%
  spread_draws(u_tau[i]) \%>\%
  median_qi(.width = c(.5, .8, .95, .99)) \%>\%
  ggplot(aes(y = i, x = u_tau)) +
  geom_intervalh() +
  scale_color_brewer()

RankCorr \%>\%
  spread_draws(u_tau[i]) \%>\%
  median_qi(.width = c(.5, .8, .95, .99)) \%>\%
  ggplot(aes(x = i, y = u_tau)) +
  geom_interval() +
  scale_color_brewer()

}
\seealso{
See \code{\link{geom_lineribbon}} for a similar geom designed for curves plus probability bands. See
\code{\link{geom_linerange}} and \code{\link{geom_linerangeh}} for the geoms these are based on.
}
\author{
Matthew Kay
}
\keyword{manip}
