% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geom_pointinterval.R, R/geom_pointintervalh.R
\name{geom_pointinterval}
\alias{geom_pointinterval}
\alias{geom_pointintervalh}
\title{Point + multiple probability interval plots (ggplot geom)}
\usage{
geom_pointinterval(mapping = NULL, data = NULL, stat = "identity",
  position = "identity", ..., size_domain = c(1, 6),
  size_range = c(0.6, 1.4), fatten_point = 1.8, na.rm = FALSE,
  show.legend = c(size = FALSE), inherit.aes = TRUE)

geom_pointintervalh(mapping = NULL, data = NULL, stat = "identity",
  position = "identity", ..., size_domain = c(1, 6),
  size_range = c(0.6, 1.4), fatten_point = 1.8, na.rm = FALSE,
  show.legend = c(size = FALSE), inherit.aes = TRUE)
}
\arguments{
\item{mapping}{The aesthetic mapping, usually constructed with
\code{\link{aes}} or \code{\link{aes_string}}. Only needs to be set at the
layer level if you are overriding the plot defaults.}

\item{data}{A layer specific dataset - only needed if you want to override
the plot defaults.}

\item{stat}{The statistical transformation to use on the data for this layer.}

\item{position}{The position adjustment to use for overlapping points on this layer.}

\item{...}{Other arguments passed to \code{\link{layer}}.}

\item{size_domain}{The minimum and maximum of the values of the size aesthetic that will be translated into actual
sizes drawn according to \code{size_range} (see the documentation for that argument, below.)}

\item{size_range}{This geom scales the raw size aesthetic values, as they tend to be too thick when using the default
settings of \code{\link{scale_size_continuous}}, which give sizes with a range of \code{c(1, 6)}. The
\code{size_domain} value indicates the input domain of raw size values (typically this should be equal to the value
of the \code{range} argument of the \code{\link{scale_size_continuous}} function), and \code{size_range} indicates
the desired output range of the size values (the min and max of the actual sizes used to draw intervals).}

\item{fatten_point}{A multiplicative factor used to adjust the size of the point relative to the size of the
thickest line.}

\item{na.rm}{If \code{FALSE}, the default, missing values are removed with a warning. If \code{TRUE}, missing
values are silently removed.}

\item{show.legend}{Should this layer be included in the legends? Default is \code{c(size = FALSE)}, unlike most geoms,
to match its common use cases. \code{FALSE} hides all legends, \code{TRUE} shows all legends, and \code{NA} shows only
those that are mapped (the default for most geoms).}

\item{inherit.aes}{If \code{FALSE}, overrides the default aesthetics, rather than combining with them. This is
most useful for helper functions that define both data and aesthetics and shouldn't inherit behavior from the
default plot specification, e.g. borders.}
}
\description{
Modified versions of \code{\link{geom_pointrange}} and \code{\link{geom_pointrangeh}} with default aesthetics
designed for use with output from \code{\link{point_interval}}.
}
\details{
\code{geom_pointinterval} is a modified version of \code{\link{geom_pointrange}}, and \code{geom_pointintervalh} is
a modified version of \code{\link{geom_pointrangeh}}. These geoms set some default aesthetics equal
to the \code{.lower}, \code{.upper}, and \code{.width} columns generated by the \code{point_interval} family
of functions, making them often more convenient than vanilla \code{\link{geom_pointrange}} or
\code{\link{geom_pointrangeh}} when used with functions like \code{\link{median_qi}}, \code{\link{mean_qi}},
\code{\link{mode_hdi}}, etc.

Specifically, \code{geom_pointinterval} acts as if its default aesthetics are
\code{aes(ymin = .lower, ymax = .upper, size = -.width)}. \code{geom_pointintervalh} acts as if its default
aesthetics are \code{aes(xmin = .lower, xmax = .upper, size = -.width)}.

Both geoms provides a scaling factor for line width as well as point size through the \code{fatten.interval} and
\code{fatten.point} arguments; this scaling factor is designed to give multiple probability intervals reasonable
scaling at the default settings for \code{\link{scale_size_continuous}}. Finally, these geoms default to not
displaying the legend, though this can be overridden through setting \code{show.legend = NA} (the setting for most
geoms) or \code{show.legend = TRUE}.
}
\examples{

library(magrittr)
library(ggplot2)

data(RankCorr, package = "tidybayes")

RankCorr \%>\%
  spread_draws(u_tau[i]) \%>\%
  median_qi(.width = c(.8, .95)) \%>\%
  ggplot(aes(y = i, x = u_tau)) +
  geom_pointintervalh()

RankCorr \%>\%
  spread_draws(u_tau[i]) \%>\%
  median_qi(.width = c(.8, .95)) \%>\%
  ggplot(aes(x = i, y = u_tau)) +
  geom_pointinterval()

}
\seealso{
See \code{\link{geom_lineribbon}} for a similar geom designed for curves plus probability bands. See
\code{\link{geom_pointrange}} and \code{\link{geom_pointrangeh}} for the geoms these are based on.
}
\author{
Matthew Kay
}
\keyword{manip}
