% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/flows.R
\name{get_flows}
\alias{get_flows}
\title{Obtain data and feature geometry for American Community Survey Migration
Flows}
\usage{
get_flows(
  geography,
  variables = NULL,
  breakdown = NULL,
  breakdown_labels = FALSE,
  year = 2018,
  output = "tidy",
  state = NULL,
  county = NULL,
  msa = NULL,
  geometry = FALSE,
  key = NULL,
  moe_level = 90,
  show_call = FALSE
)
}
\arguments{
\item{geography}{The geography of your requested data. Possible values are
`"county"`, `"county subdivision"`, and `"metropolitan statistical area"`.
MSA data is only available beginning with the 2009-2013 5-year ACS.}

\item{variables}{Character string or vector of character strings of variable
names. By default, `get_flows()` returns the GEOID and names of the
geographies as well as the number of people who moved in, out, and net
movers of each geography (`MOVEDIN`, `MOVEDOUT`, `MOVEDNET`). If additional
variables are specified, they are pulled in addition to the default
variables. The names of additional variables can be found in the Census
Migration Flows API
documentation at \url{https://api.census.gov/data/2018/acs/flows/variables.html}.}

\item{breakdown}{A character vector of the population breakdown
characteristics to be crossed with migration flows data. For datasets
between 2006-2010 and 2011-2015, selected demographic characteristics such
as age, race, employment status, etc. are available. Possible values are
`"AGE"`, `"SEX"`, `"RACE"`, `"HSGP"`, `"REL"`, `"HHT"`, `"TEN"`, `"ENG"`,
`"POB"`, `"YEARS"`, `"ESR"`, `"OCC"`, `"WKS"`, `"SCHL"`, `"AHINC"`,
`"APINC"`, and `"HISP_ORIGIN"`. For more information and to see which
characteristics are available in each year, visit the Census Migration
Flows
documentation at \url{https://www.census.gov/data/developers/data-sets/acs-migration-flows.html}.
 Note: not all characteristics are available in all years.}

\item{breakdown_labels}{Whether or not to add columns with labels for the
breakdown characteristic codes. Defaults to `FALSE`.}

\item{year}{The year, or endyear, of the ACS sample. The Migration Flows API
is available for 5-year ACS samples from 2010 to 2018. Defaults to 2018.}

\item{output}{One of "tidy" (the default) in which each row represents an
enumeration unit-variable combination, or "wide" in which each row
represents an enumeration unit and the variables are in the columns.}

\item{state}{An optional vector of states for which you are requesting data.
State names, postal codes, and FIPS codes are accepted. When requesting
county subdivision data, you must specify at least one state.}

\item{county}{The county for which you are requesting data. County names and
FIPS codes are accepted. Must be combined with a value supplied to `state`.}

\item{msa}{The metropolitan statistical area for which you are requesting
data. Specify a single value or a vector of values to get data for more
than one MSA. Numeric or character MSA GEOIDs are accepted. When specifying
MSAs, geography must be set to `"metropolitan statistical area"` and
`state` and `county` must be `NULL`.}

\item{geometry}{if FALSE (the default), return a tibble of ACS Migration
Flows data. If TRUE, return an sf object with the centroids of both origin
and destination as `sfc_POINT` columns. The origin point feature is
returned in a column named `centroid1` and is the active geometry column in
the sf object. The destination point feature is returned in the `centroid2`
column.}

\item{key}{Your Census API key. Obtain one at
\url{https://api.census.gov/data/key_signup.html}}

\item{moe_level}{The confidence level of the returned margin of error.  One
of 90 (the default), 95, or 99.}

\item{show_call}{if TRUE, display call made to Census API. This can be very
useful in debugging and determining if error messages returned are due to
tidycensus or the Census API. Copy to the API call into a browser and see
what is returned by the API directly. Defaults to FALSE.}
}
\value{
A tibble or sf tibble of ACS Migration Flows data
}
\description{
Obtain data and feature geometry for American Community Survey Migration
Flows
}
\examples{
\dontrun{
get_flows(
  geography = "county",
  state = "VT",
  county = c("Washington", "Chittenden")
  )

get_flows(
  geography = "county subdivision",
  breakdown = "RACE",
  breakdown_labels = TRUE,
  state = "NY",
  county = "Westchester",
  output = "wide",
  year = 2015
  )

get_flows(
   geography = "metropolitan statistical area",
   variables = c("POP1YR", "POP1YRAGO"),
   geometry = TRUE,
   output = "wide",
   show_call = TRUE
  )
}
}
