% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metric-silhouette.R
\name{silhouette}
\alias{silhouette}
\title{Measures silhouette between clusters}
\usage{
silhouette(object, new_data = NULL, dists = NULL, dist_fun = Rfast::Dist)
}
\arguments{
\item{object}{A fitted tidyclust model}

\item{new_data}{A dataset to predict on.  If \code{NULL}, uses trained clustering.}

\item{dists}{A distance matrix. Used if \code{new_data} is \code{NULL}.}

\item{dist_fun}{A function for calculating distances between observations.
Defaults to Euclidean distance on processed data.}
}
\value{
A tibble giving the silhouette for each observation.
}
\description{
Measures silhouette between clusters
}
\details{
\code{\link[=silhouette_avg]{silhouette_avg()}} is the corresponding cluster metric function that
returns the average of the values given by \code{silhouette()}.
}
\examples{
kmeans_spec <- k_means(num_clusters = 5) \%>\%
  set_engine("stats")

kmeans_fit <- fit(kmeans_spec, ~., mtcars)

dists <- mtcars \%>\%
  as.matrix() \%>\%
  dist()

silhouette(kmeans_fit, dists = dists)
}
