% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tidydice.R
\name{flip_coin}
\alias{flip_coin}
\title{Simulating flipping a coin.}
\usage{
flip_coin(data = NULL, times = 1, rounds = 1, success = c(2),
  agg = FALSE, sides = 2, prob = NULL, seed = NULL)
}
\arguments{
\item{data}{Data from a previous experiment}

\item{times}{How many times coin is flipped (or how many coins are flipped at the same time)}

\item{rounds}{Number of rounds}

\item{success}{Which result is a success (default = 2)}

\item{agg}{If TRUE, the result is aggregated (by experiment, rounds)}

\item{sides}{Number of sides of the coin (default = 2)}

\item{prob}{Vector of probabilities for each side of the coin}

\item{seed}{Seed to produce reproducible results}
}
\value{
Result of experiment as a tibble
}
\description{
Flipping a coin is simulated using sample(). The default coin has 2 sides and is fair.
The properties of the coin can be changed.
The result is returned as a tibble.
}
\examples{
# flipping a coin
flip_coin()

# flipping a coin 10 times
flip_coin(times = 10)

# aggregate result
flip_coin(times = 10, agg = TRUE)

# rounds 
flip_coin(times = 10, rounds = 3, agg = TRUE)

# experiments
library(dplyr)
flip_coin(times = 10, rounds = 3, agg = TRUE) \%>\% 
  flip_coin(times = 12, rounds = 3, agg = TRUE) 
}
