% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/group_by.R
\name{group_by_dt}
\alias{group_by_dt}
\alias{group_exe_dt}
\title{Group by variable(s) and implement operations}
\usage{
group_by_dt(.data, ..., cols = NULL, inplace = FALSE)

group_exe_dt(.data, ...)
}
\arguments{
\item{.data}{A data frame}

\item{...}{Variables to group by for \code{group_by_dt},
namely the columns to sort by. Do not quote the column names.
Any data manipulation arguments that could be
implemented on a data.frame for \code{group_exe_dt}.
It can receive what \code{select_dt} receives.}

\item{cols}{A character vector of column names to group by.}

\item{inplace}{Should the grouping implemented by reference?
(Modify the original data.frame) Default uses \code{FALSE}.}
}
\value{
A data.table
}
\description{
Using \code{setkey} and \code{setkeyv} in \pkg{data.table}
to carry out \code{group_by}-like functionalities in \pkg{dplyr}. This is
not only convenient but also efficient in computation.
}
\details{
\code{group_by_dt} and \code{group_exe_dt} are a pair of functions
to be used in combination. It utilizes the feature of key setting in data.table,
which provides high performance for group operations, especially when you have
to operate by specific groups frequently.
}
\examples{
# group by Species in iris data set
as.data.table(iris) -> a
key(a)
group_by_dt(a,Species,inplace = FALSE)
key(a)

# use inplace operation to group by reference
as.data.table(iris) -> a
key(a)
group_by_dt(a,Species,inplace = TRUE)
key(a)

# aggregation after grouping using group_exe_dt
as.data.table(iris) -> a
a \%>\%
  group_by_dt(Species) \%>\%
  group_exe_dt(head(1))

a \%>\%
  group_by_dt(Species) \%>\%
  group_exe_dt(
    head(3) \%>\%
      summarise_dt(sum = sum(Sepal.Length))
  )

mtcars \%>\%
  group_by_dt("cyl|am") \%>\%
  group_exe_dt(
    summarise_dt(mpg_sum = sum(mpg))
  )
# equals to
mtcars \%>\%
  group_by_dt(cols = c("cyl","am")) \%>\%
  group_exe_dt(
    summarise_dt(mpg_sum = sum(mpg))
  )
}
