% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tbl_json.R
\name{tbl_json}
\alias{tbl_json}
\alias{as.tbl_json}
\alias{as_tbl_json}
\alias{as.tbl_json.tbl_json}
\alias{as.tbl_json.character}
\alias{as.tbl_json.list}
\alias{as.tbl_json.data.frame}
\alias{is.tbl_json}
\title{Combines structured JSON (as a data.frame) with remaining JSON}
\usage{
tbl_json(df, json.list, drop.null.json = FALSE, ..., .column_order = NULL)

as.tbl_json(.x, ...)

as_tbl_json(.x, ...)

\method{as.tbl_json}{tbl_json}(.x, ...)

\method{as.tbl_json}{character}(.x, ...)

\method{as.tbl_json}{list}(.x, ...)

\method{as.tbl_json}{data.frame}(.x, json.column, ...)

is.tbl_json(.x)
}
\arguments{
\item{df}{data.frame}

\item{json.list}{list of json lists parsed with
\code{\link[jsonlite]{fromJSON}}}

\item{drop.null.json}{drop \code{NULL} json entries from \code{df} and
\code{json.list}}

\item{...}{other arguments}

\item{.column_order}{Experimental argument to preserve column order for the hidden column}

\item{.x}{an object to convert into a \code{tbl_json} object}

\item{json.column}{the name of the json column of data in \code{.x}, if
\code{.x} is a data frame}
}
\value{
a \code{\link{tbl_json}} object
}
\description{
Constructs a \code{tbl_json} object, for further downstream manipulation
by other tidyjson functions. Methods exist to convert JSON stored in
character strings without any other associated data, as a separate
character string and associated data frame, or as a single data frame
with a specified character string JSON column.
}
\details{
Most tidyjson functions accept a \code{tbl_json} object as the first
argument, and return a \code{tbl_json} object unless otherwise specified.
tidyjson functions will attempt to convert an object that isn't a
\code{tbl_json} object first, and so explicit construction of \code{tidyjson}
objects is rarely needed.

\code{tbl_json} objects consist of a data frame along with it's associated
JSON, where each row of the data frame corresponds to a single JSON
document. The JSON is stored in a \code{"JSON"} attribute.

Note that \code{json.list} must have the same length as \code{nrow(df)}, and
if \code{json.list} has any \code{NULL} elements, the corresponding rows will
be removed from \code{df}. Also note that \code{"..JSON"} is a reserved
column name used internally for filtering tbl_json objects, and so is not
allowed in the names of \code{df}.
}
\examples{

# Construct a tbl_json object using a charater string of JSON
json <- '{"animal": "cat", "count": 2}'
json \%>\% as.tbl_json

# access the "JSON" argument
json \%>\% as.tbl_json \%>\% attr("JSON")

# Construct a tbl_json object using multiple documents
json <- c('{"animal": "cat", "count": 2}', '{"animal": "parrot", "count": 1}')
json \%>\% as.tbl_json

# Construct a tbl_json object from a data.frame with a JSON colum
library(tibble)
farms <- tribble(
  ~farm, ~animals,
  1L,    '[{"animal": "pig", "count": 50}, {"animal": "cow", "count": 10}]',
  2L,    '[{"animal": "chicken", "count": 20}]'
)
farms \%>\% as.tbl_json(json.column = "animals")
# tidy the farms
farms \%>\% as.tbl_json(json.column = "animals") \%>\%
  gather_array \%>\% spread_all
}
\seealso{
\code{read_json} for reading json from files
}
