% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/api_groq.R
\name{groq_chat}
\alias{groq_chat}
\title{Send LLM Messages to the Groq Chat API}
\usage{
groq_chat(
  .llm,
  .model = "deepseek-r1-distill-llama-70b",
  .max_tokens = 1024,
  .temperature = NULL,
  .top_p = NULL,
  .frequency_penalty = NULL,
  .presence_penalty = NULL,
  .stop = NULL,
  .seed = NULL,
  .tools = NULL,
  .tool_choice = NULL,
  .api_url = "https://api.groq.com/",
  .json = FALSE,
  .timeout = 60,
  .verbose = FALSE,
  .stream = FALSE,
  .dry_run = FALSE,
  .max_tries = 3
)
}
\arguments{
\item{.llm}{An \code{LLMMessage} object containing the conversation history.}

\item{.model}{The identifier of the model to use (default: "llama-3.2-11b-vision-preview").}

\item{.max_tokens}{The maximum number of tokens that can be generated in the response (default: 1024).}

\item{.temperature}{Controls the randomness in the model's response. Values between 0 and 2 are allowed, where higher values increase randomness (optional).}

\item{.top_p}{Nucleus sampling parameter that controls the proportion of probability mass considered. Values between 0 and 1 are allowed (optional).}

\item{.frequency_penalty}{Number between -2.0 and 2.0. Positive values penalize repeated tokens, reducing likelihood of repetition (optional).}

\item{.presence_penalty}{Number between -2.0 and 2.0. Positive values encourage new topics by penalizing tokens that have appeared so far (optional).}

\item{.stop}{One or more sequences where the API will stop generating further tokens. Can be a string or a list of strings (optional).}

\item{.seed}{An integer for deterministic sampling. If specified, attempts to return the same result for repeated requests with identical parameters (optional).}

\item{.tools}{Either a single TOOL object or a list of TOOL objects representing the available functions for tool calls (optional).}

\item{.tool_choice}{A character string specifying the tool-calling behavior; valid values are "none", "auto", or "required" (optional).}

\item{.api_url}{Base URL for the Groq API (default: "https://api.groq.com/").}

\item{.json}{Whether the response should be structured as JSON (default: FALSE).}

\item{.timeout}{Request timeout in seconds (default: 60).}

\item{.verbose}{If TRUE, displays additional information after the API call, including rate limit details (default: FALSE).}

\item{.stream}{Logical; if TRUE, streams the response piece by piece (default: FALSE).}

\item{.dry_run}{If TRUE, performs a dry run and returns the constructed request object without executing it (default: FALSE).}

\item{.max_tries}{Maximum retries to peform request}
}
\value{
A new \code{LLMMessage} object containing the original messages plus the assistant's response.
}
\description{
This function sends a message history to the Groq Chat API and returns the assistant's reply.
}
\examples{
\dontrun{
# Basic usage
msg <- llm_message("What is Groq?")
result <- groq_chat(msg)

# With custom parameters
result2 <- groq_chat(msg, 
               .model = "llama-3.2-vision",
               .temperature = 0.5, 
               .max_tokens = 512)
}

}
