% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/api_claude.R
\name{claude}
\alias{claude}
\title{Provider Function for Claude models on the Anthropic API}
\usage{
claude(..., .called_from = NULL)
}
\arguments{
\item{...}{Parameters to be passed to the appropriate OpenAI-specific function,
such as model configuration, input text, or API-specific options.}

\item{.called_from}{An internal argument that specifies which action (e.g.,
\code{chat}, \code{send_batch}) the function is being invoked from.
This argument is automatically managed and should not be modified by the user.}
}
\value{
The result of the requested action, depending on the specific function invoked
(e.g., an updated \code{LLMMessage} object for \code{chat()}, or a matrix for \code{embed()}).
}
\description{
The \code{claude()} function acts as an interface for interacting with the Anthropic API
through main \code{tidyllm} verbs such as \code{chat()}, \code{embed()}, and
\code{send_batch()}. It dynamically routes requests to Claude-specific functions
like \code{claude_chat()} and \code{send_claude_batch()} based on the context of the call.
}
