% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/llm_verbs.R
\name{embed}
\alias{embed}
\title{Generate text embeddings}
\usage{
embed(
  .input,
  .provider = getOption("tidyllm_embed_default"),
  .model = NULL,
  .truncate = NULL,
  .timeout = NULL,
  .dry_run = NULL,
  .max_tries = NULL
)
}
\arguments{
\item{.input}{A character vector of texts v, a list of texts and image objects,  or an \code{LLMMessage} object}

\item{.provider}{A function or function call specifying the language model provider and any additional parameters.
This should be a call to a provider function like \code{openai()}, \code{ollama()}, etc.
You can also set a default provider function via the \code{tidyllm_embed_default} option.}

\item{.model}{The embedding model to use}

\item{.truncate}{Whether to truncate inputs to fit the model's context length}

\item{.timeout}{Timeout for the API request in seconds}

\item{.dry_run}{If TRUE, perform a dry run and return the request object.}

\item{.max_tries}{Maximum retry attempts for requests}
}
\value{
A tibble with two columns: \code{input} and \code{embeddings}.
The \code{input} column contains the texts sent to embed, and the \code{embeddings} column
is a list column where each row contains an embedding vector of the sent input.
}
\description{
The \code{embed()} function allows you to embed a text via a specified provider.
It routes the input to the appropriate provider-specific embedding function.
}
\examples{
\dontrun{
c("What is the meaning of life, the universe and everything?",
 "How much wood would a woodchuck chuck?",
 "How does the brain work?") |>
 embed(gemini)
 }
}
