% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gt_admixture.R
\name{gt_admixture}
\alias{gt_admixture}
\title{Run ADMIXTURE from R}
\usage{
gt_admixture(
  x,
  k,
  n_runs = 1,
  crossval = FALSE,
  n_cores = 1,
  seed = NULL,
  conda_env = "auto"
)
}
\arguments{
\item{x}{a \code{gen_tibble} or a character giving the path of the input PLINK bed
file}

\item{k}{an integer giving the number of clusters}

\item{n_runs}{the number of runs for each k value (defaults to 1)}

\item{crossval}{boolean, should cross validation be used to assess the fit
(defaults to FALSE)}

\item{n_cores}{number of cores (defaults to 1)}

\item{seed}{the seed for the random number generator (defaults to NULL)}

\item{conda_env}{the name of the conda environment to use. "none" forces the
use of a local copy, whilst any other string will direct the function to
use a custom conda environment.}
}
\value{
an object of class \code{gt_admix} consisting of a list with the following
elements:
\itemize{
\item \code{k} the number of clusters
\item \code{Q} a matrix with the admixture proportions
\item \code{P} a matrix with the allele frequencies
\item \code{log} a log of the output generated by ADMIXTURE
(usually printed on the screen when running from the command line)
\item \code{cv} the cross validation error (if \code{crossval} is TRUE)
\item \code{loglik} the log likelihood of the model
\item \code{id} the id column of the input \code{gen_tibble} (if applicable)
\item \code{group} the group column of the input \code{gen_tibble} (if applicable)
}
}
\description{
This function runs ADMIXTURE, taking either a \code{gen_tibble} or a file as an
input. This is a wrapper that runs ADMIXTURE from the command line, and reads
the output into R. It can run multiple values of \code{k} and multiple repeats for
each \code{k}.
}
\details{
This is a wrapper for the command line program ADMIXTURE. It can
either use a binary present in the main environment, or use a copy
installed in a conda environment.
}
\examples{
# run the example only if we have the package installed
\dontrun{
bed_file <-
  system.file("extdata", "lobster", "lobster.bed", package = "tidypopgen")
lobsters <- gen_tibble(bed_file,
  backingfile = tempfile("lobsters"),
  quiet = TRUE
)
lobsters <- lobsters \%>\% group_by(population)
gt_admixture(lobsters,
  k = 2:3, seed = c(1, 2),
  n_runs = 2, crossval = TRUE
)
}
}
