% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/autoplot_gt_pcadapt.R
\name{autoplot_gt_pcadapt}
\alias{autoplot_gt_pcadapt}
\alias{autoplot.gt_pcadapt}
\title{Autoplots for \code{gt_pcadapt} objects}
\usage{
\method{autoplot}{gt_pcadapt}(object, type = c("qq", "manhattan"), ...)
}
\arguments{
\item{object}{an object of class \code{gt_pcadapt}}

\item{type}{the type of plot (one of "qq", and "manhattan")}

\item{...}{further arguments to be passed to \code{\link[bigsnpr:snp_qq]{bigsnpr::snp_qq()}} or
\code{\link[bigsnpr:snp_manhattan]{bigsnpr::snp_manhattan()}}.}
}
\value{
a \code{ggplot2} object
}
\description{
For \code{gt_pcadapt}, the following types of plots are available:
\itemize{
\item \code{qq}: a quantile-quantile plot of the p-values from \code{pcadapt}
(wrapping \code{\link[bigsnpr:snp_qq]{bigsnpr::snp_qq()}})
\item \code{manhattan} a manhattan plot of the p-values from \code{pcadapt}
(wrapping \code{\link[bigsnpr:snp_manhattan]{bigsnpr::snp_manhattan()}})
}
}
\details{
\code{autoplot} produces simple plots to quickly inspect an object. They are
not customisable; we recommend that you use \code{ggplot2} to produce publication
ready plots.
}
\examples{
# Create a gen_tibble of lobster genotypes
bed_file <-
  system.file("extdata", "lobster", "lobster.bed", package = "tidypopgen")
lobsters <- gen_tibble(bed_file,
  backingfile = tempfile("lobsters"),
  quiet = TRUE
)

# Remove monomorphic loci and impute
lobsters <- lobsters \%>\% select_loci_if(loci_maf(genotypes) > 0)
lobsters <- gt_impute_simple(lobsters, method = "mode")

# Create PCA object
pca <- gt_pca_partialSVD(lobsters)

# Create a gt_pcadapt object
pcadapt_obj <- gt_pcadapt(lobsters, pca, k = 2)

# Plot the p-values from pcadapt
autoplot(pcadapt_obj, type = "qq")

# Plot the manhattan plot of the p-values from pcadapt
autoplot(pcadapt_obj, type = "manhattan")

}
