% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tidyquant.R
\docType{package}
\name{tidyquant}
\alias{tidyquant}
\alias{tidyquant-package}
\title{tidyquant: Integrating quantitative financial analysis tools with the tidyverse}
\description{
The main advantage of \code{tidyquant} is to
bridge the gap between the best quantitative resources for collecting and
manipulating quantitative data, \code{xts}, \code{quantmod} and \code{TTR},
and the data modeling workflow and infrastructure of the \code{tidyverse}.
}
\details{
In this package, \code{tidyquant} functions and supporting data sets are
provided to seamlessly combine tidy tools with existing quantitative
analytics packages. The main advantage is being able to use tidy
functions with purrr for mapping and tidyr for nesting to extend modeling to
many stocks. See the tidyquant website for more information, documentation
and examples.

Users will probably be interested in the following:
\itemize{
\item \strong{Getting Data from the Web:} \code{\link[=tq_get]{tq_get()}}
\item \strong{Manipulating Data:} \code{\link[=tq_transmute]{tq_transmute()}} and \code{\link[=tq_mutate]{tq_mutate()}}
\item \strong{Coercing Data To and From xts and tibble:} \code{\link[=as_tibble]{as_tibble()}}
and \code{\link[=as_xts]{as_xts()}}
}

To learn more about tidyquant, start with the vignettes:
\code{browseVignettes(package = "tidyquant")}
}
