% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tq_get.R
\name{tq_get}
\alias{tq_get}
\alias{tq_get_options}
\alias{tq_get_stock_index_options}
\title{Get quantitative data in \code{tibble} format}
\usage{
tq_get(x, get = "stock.prices", complete_cases = TRUE, ...)

tq_get_options()

tq_get_stock_index_options()
}
\arguments{
\item{x}{A single character string, a character vector or tibble representing a single (or multiple)
stock symbol, metal symbol, currency combination, FRED code, etc.}

\item{get}{A character string representing the type of data to get
for \code{x}. Options include:
\itemize{
\item \code{"stock.prices"}: Get the open, high, low, close, volume and adjusted
stock prices for a stock symbol from
\href{https://finance.yahoo.com/}{Yahoo Finance}. Wrapper for \code{quantmod::getSymbols()}.
\item \code{"stock.prices.google"}: Get the open, high, low, close, and volume
stock prices for a stock symbol from
\href{https://finance.google.com/finance}{Google Finance}. Wrapper for \code{quantmod::getSymbols.google()}.
\item \code{"stock.prices.japan"}: Get the open, high, low, close, volume and adjusted
stock prices for a stock symbol from
\href{http://finance.yahoo.co.jp/}{Yahoo Finance Japan}. Wrapper for \code{quantmod::getSymbols.yahooj()}.
\item \code{"financials"}: Get the income, balance sheet, and cash flow
financial statements for a stock symbol from
\href{https://www.google.com/finance}{Google Finance}. Wrapper for \code{quantmod::getFinancials()}.
\item \code{"key.ratios"}: Get 89 historical growth, profitablity, financial health,
efficiency, and valuation ratios that span 10-years from
\href{https://www.morningstar.com}{Morningstar}.
\item \code{"key.stats"}: DISCONTINUED.
\item \code{"dividends"}: Get the dividends for a stock symbol
from \href{https://finance.yahoo.com/}{Yahoo Finance}. Wrapper for \code{quantmod::getDividends()}.
\item \code{"splits"}: Get the splits for a stock symbol
from \href{https://finance.yahoo.com/}{Yahoo Finance}. Wrapper for \code{quantmod::getSplits()}.
\item \code{"economic.data"}: Get economic data from
\href{https://fred.stlouisfed.org/}{FRED}. rapper for \code{quantmod::getSymbols.FRED()}.
\item \code{"metal.prices"}: Get the metal prices from
\href{https://www.oanda.com/}{Oanda}. Wrapper for \code{quantmod::getMetals()}.
\item \code{"exchange.rates"}: Get exchange rates from
\href{https://www.oanda.com/currency/converter/}{Oanda}. Wrapper for \code{quantmod::getFX()}.
\item \code{"quandl"}: Get data sets from
\href{https://www.quandl.com/}{Quandl}. Wrapper for \code{Quandl::Quandl()}.
See also \code{\link[=quandl_api_key]{quandl_api_key()}}.
\item \code{"quandl.datatable"}: Get data tables from
\href{https://www.quandl.com/}{Quandl}. Wrapper for \code{Quandl::Quandl.datatable()}.
See also \code{\link[=quandl_api_key]{quandl_api_key()}}.
\item \code{"alphavantager"}: Get data sets from
\href{https://www.alphavantage.co/}{Alpha Vantage}. Wrapper for \code{alphavantager::av_get()}.
See also \code{\link[=av_api_key]{av_api_key()}}.
\item \code{"rblpapi"}: Get data sets from
\href{https://www.bloomberg.com/professional/solution/bloomberg-terminal}{Bloomberg}. Wrapper for \code{Rblpapi}.
See also \code{\link[Rblpapi:blpConnect]{Rblpapi::blpConnect()}} to connect to Bloomberg terminal (required).
Use the argument \code{rblpapi_fun} to set the function such as "bdh" (default), "bds", or "bdp".
}}

\item{complete_cases}{Removes symbols that return an NA value due to an error with the get
call such as sending an incorrect symbol "XYZ" to get = "stock.prices". This is useful in
scaling so user does not need to
add an extra step to remove these rows. \code{TRUE} by default, and a warning
message is generated for any rows removed.}

\item{...}{Additional parameters passed to the "wrapped"
function. Investigate underlying functions to see full list of arguments.
Common optional parameters include:
\itemize{
\item \code{from}: Optional for various time series functions in quantmod / quandl packages.
A character string representing a start date in
YYYY-MM-DD format. No effect on
\code{"financials"}, \code{"key.ratios"}, or \code{"key.stats"}.
\item \code{to}: Optional for various time series functions in quantmod / quandl packages.
A character string representing a end date in
YYYY-MM-DD format. No effect on
\code{get = "financials"},  \code{"key.ratios"}, or \code{"key.stats"}.
}}
}
\value{
Returns data in the form of a \code{tibble} object.
}
\description{
Get quantitative data in \code{tibble} format
}
\details{
\code{tq_get()} is a consolidated function that gets data from various
web sources. The function is a wrapper for several \code{quantmod}
functions, \code{Quandl} functions, and also gets data from websources unavailable
in other packages.
The results are always returned as a \code{tibble}. The advantages
are (1) only one function is needed for all data sources and (2) the function
can be seemlessly used with the tidyverse: \code{purrr}, \code{tidyr}, and
\code{dplyr} verbs.

\code{tq_get_options()} returns a list of valid \code{get} options you can
choose from.

\code{tq_get_stock_index_options()} Is deprecated and will be removed in the
next version. Please use \code{tq_index_options()} instead.
}
\examples{
# Load libraries
library(tidyquant)

# Get the list of `get` options
tq_get_options()

# Get stock prices for a stock from Yahoo
aapl_stock_prices <- tq_get("AAPL")

# Get stock prices for multiple stocks
mult_stocks <- tq_get(c("FB", "AMZN"),
                      get  = "stock.prices",
                      from = "2016-01-01",
                      to   = "2017-01-01")

# Multiple gets
mult_gets <- tq_get("AAPL",
                    get = c("stock.prices", "financials"),
                    from = "2016-01-01",
                    to   = "2017-01-01")
}
\seealso{
\itemize{
\item \code{\link[=tq_index]{tq_index()}} to get a ful list of stocks in an index.
\item \code{\link[=tq_exchange]{tq_exchange()}} to get a ful list of stocks in an exchange.
\item \code{\link[=quandl_api_key]{quandl_api_key()}} to set the api key for collecting data via the \code{"quandl"}
get option.
\item \code{\link[=av_api_key]{av_api_key()}} to set the api key for collecting data via the \code{"alphavantage"}
get option.
}
}
