% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scale_manual.R
\name{scale_manual}
\alias{scale_manual}
\alias{scale_color_tq}
\alias{scale_colour_tq}
\alias{scale_fill_tq}
\title{tidyquant colors and fills for ggplot2.}
\usage{
scale_color_tq(..., theme = "light")

scale_colour_tq(..., theme = "light")

scale_fill_tq(..., theme = "light")
}
\arguments{
\item{...}{common discrete scale parameters: \code{name}, \code{breaks}, \code{labels}, \code{na.value}, \code{limits} and \code{guide}. See \code{\link[=discrete_scale]{discrete_scale()}} for more details}

\item{theme}{one of "light", "dark", or "green". This should match the \code{theme_tq()} that is used with it.}
}
\description{
The tidyquant scales add colors that work nicely with \code{theme_tq()}.
}
\details{
\describe{

\item{\code{scale_color_tq}}{
For use when \code{color} is specified as an \code{aes()} in a ggplot.}

\item{\code{scale_fill_tq}}{
For use when \code{fill} is specified as an \code{aes()} in a ggplot.}
}
}
\examples{
# Load libraries
library(tidyquant)

# Get stock prices
stocks <- c("AAPL", "FB", "NFLX") \%>\%
    tq_get(from = "2013-01-01",
           to   = "2017-01-01")

# Plot for stocks
a <- stocks \%>\%
    ggplot(aes(date, adjusted, color = symbol)) +
    geom_line() +
    labs(title = "Multi stock example",
         xlab = "Date",
         ylab = "Adjusted Close")

# Plot with tidyquant theme and colors
a +
    theme_tq() +
    scale_color_tq()


}
\seealso{
\code{\link[=theme_tq]{theme_tq()}}
}
