% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/unnest.R
\name{unnest}
\alias{unnest}
\title{Unnest a list column.}
\usage{
unnest(data, ...)
}
\arguments{
\item{data}{A data frame.}

\item{...}{Specification of columns to nest. Use bare variable names.
  Select all variables between x and z with \code{x:z}, exclude y with
  \code{-y}. For more options, see the \link[dplyr]{select} documentation.

  If ommitted, defaults to all list-cols.}
}
\description{
If you have a list-column, this makes each element of the list it's own
row. List-columns can either be atomic vectors or data frames. Each
row must have the same number of entries.
}
\examples{
library(dplyr)
df <- data_frame(
  x = 1:3,
  y = c("a", "d,e,f", "g,h")
)
df \%>\%
  transform(y = strsplit(y, ",")) \%>\%
  unnest(y)

# It also works if you have a column that contains other data frames!
df <- data_frame(
  x = 1:2,
  y = list(
   data_frame(z = 1),
   data_frame(z = 3:4)
 )
)
df \%>\% unnest(y)

# You can also unnest multiple columns simultaneously
df <- data_frame(
 a = list(c("a", "b"), "c"),
 b = list(1:2, 3),
 c = c(11, 22)
)
df \%>\% unnest(a, b)
# If you omit the column names, it'll unnest all list-cols
df \%>\% unnest()

# Nest and unnest are inverses
df <- data.frame(x = c(1, 1, 2), y = 3:1)
df \%>\% nest(y)
df \%>\% nest(y) \%>\% unnest(y)
}
\seealso{
\code{\link{nest}} for the inverse operation.
}

