% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_split_balance.R
\name{check_splits_balance}
\alias{check_splits_balance}
\title{Check the balance of presences vs pseudoabsences among splits}
\usage{
check_splits_balance(splits, .col)
}
\arguments{
\item{splits}{the data splits (an \code{rset} object), generated by a function such as
\code{\link[spatialsample:spatial_block_cv]{spatialsample::spatial_block_cv()}}}

\item{.col}{the column containing the presences}
}
\value{
a table of number of presences and pseudoabsences
}
\description{
Check the balance of presences vs pseudoabsences among splits
}
\examples{
lacerta_thin <- readRDS(system.file("extdata/lacerta_climate_sf.RDS",
  package = "tidysdm"
))
lacerta_cv <- spatial_block_cv(lacerta_thin, v = 5)
check_splits_balance(lacerta_cv, class)

}
