% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/report_lm.r
\name{report_lm}
\alias{report_lm}
\title{Report method for linear regression models}
\usage{
report_lm(identifier, group = NULL, term = NULL, term_nr = NULL,
  results = getOption("tidystats_list"))
}
\arguments{
\item{identifier}{A character string identifying the model.}

\item{group}{A character string indicating the group containing the
statistics you want to report.}

\item{term}{A character string indicating the term you want to report.}

\item{term_nr}{A number indicating the term you want to report.}

\item{results}{A tidystats list.}
}
\description{
Function to report a regression in APA style.
}
\examples{
# Read in a list of results
results <- read_stats(system.file("results.csv", package = "tidystats"))

# Set the default results list
options(tidystats_list = results)

# Report results
report("lm_simple", term = "conditionmortality salience")
report("lm_simple", term_nr = 2)
report("lm_simple", group = "model")

}
