% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/count_data.r
\name{count_data}
\alias{count_data}
\title{Count the number of observations}
\usage{
count_data(data, ..., na.rm = FALSE)
}
\arguments{
\item{data}{A data frame.}

\item{...}{One or more unquoted (categorical) column names from the data
frame, separated by commas.}

\item{na.rm}{Logical. Should missing values (including NaN) be removed?}
}
\description{
\code{count_data} returns the number of observations for categorical
variables.
}
\details{
The data frame can be grouped using \strong{dplyr}'s \code{group_by}
so that the number of observations will be calculated for each group level.
}
\examples{
# Load dplyr for access to the \%>\% operator and group_by()
library(dplyr)

# 1 variable
count_data(quote_source, source)

# 2 variables
count_data(quote_source, source, sex)

# Ignore missing values
count_data(quote_source, source, sex, na.rm = TRUE)

# Use group_by() to get percentages within each group
quote_source \%>\%
  group_by(source) \%>\%
  count_data(sex)

}
