% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{quote_source}
\alias{quote_source}
\title{A many labs replication of Lorge & Curtiss (1936)}
\format{A data frame with 6343 rows and 15 columns:
\describe{
  \item{ID}{participant number}
  \item{source}{attributed source of the quote: Washington or Bin 
    Laden}
  \item{response}{evaluation of the quote on a 9-point Likert 
    scale, with 1 indicating disagreement and 9 indicating agreement}
  \item{age}{participant's age}
  \item{sex}{participant's sex}
  \item{citizenship}{participant's citizenship}
  \item{race}{participant's race}
  \item{major}{participant's major}
  \item{native_language}{participant's native language}
  \item{referrer}{location of where the study was conducated}
  \item{compensation}{how the participant was compensated for their 
    participation}
  \item{recruitment}{how the participant was recruited}
  \item{separated_or_not}{description of how the study was administered in 
    terms of participant isolation}
  \item{us_or_international}{whether the study was conducted in the US or 
   outside of the US (international)}
  \item{lab_or_online}{whether the study was conducted in the lab or online}   
}}
\usage{
quote_source
}
\description{
Data of multiple replication studies of Lorge & Curtiss (1936) from the Many 
Labs project (Klein et al., 2014).
}
\details{
Lorge and Curtiss (1936) examined how a quotation is perceived when 
it is attributed to a liked or disliked individual. The quotation of interest 
was, ‘‘I hold it that a little rebellion, now and then, is a good thing, and 
as necessary in the political world as storms are in the physical world.’’ 
In one condition the quotation was attributed to Thomas Jefferson, a liked 
individual, and in the other it was attributed to Vladimir Lenin, a disliked 
individual. More agreement was observed when the quotation was attributed to 
Jefferson than Lenin. In the replication studies, the quotation was 
attributed to either George Washington, the liked individual, or Osama Bin 
Laden, the disliked individual.
}
\references{
Lorge, I., & Curtiss, C. C. (1936). Prestige, suggestion, and attitudes. 
The Journal of Social Psychology, 7, 386-402. 
\url{https://doi.org/10.1080/00224545.1936.9919891}

Klein, R.A. et al. (2014) Investigating Variation in Replicability: A "Many 
Labs" Replication Project. Social Psychology, 45(3), 142-152. 
\url{https://dx.doi.org/10.1027/1864-9335/a000178}
}
\keyword{datasets}
