% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/slice.R
\name{slice.}
\alias{slice.}
\alias{slice_head.}
\alias{slice_tail.}
\alias{slice_max.}
\alias{slice_min.}
\alias{dt_slice}
\alias{dt_slice_head}
\alias{dt_slice_tail}
\alias{dt_slice_min}
\alias{dt_slice_max}
\title{Choose rows by position}
\usage{
slice.(.data, rows = 1:5, by = NULL)

slice_head.(.data, n = 5, by = NULL)

slice_tail.(.data, n = 5, by = NULL)

slice_max.(.data, order_by, n = 1, by = NULL)

slice_min.(.data, order_by, n = 1, by = NULL)

dt_slice(.data, rows = 1:5, by = NULL)

dt_slice_head(.data, n = 5, by = NULL)

dt_slice_tail(.data, n = 5, by = NULL)

dt_slice_min(.data, order_by, n = 1, by = NULL)

dt_slice_max(.data, order_by, n = 1, by = NULL)
}
\arguments{
\item{.data}{A data.frame or data.table}

\item{rows}{Integer row values. Provide either positive values to keep, or negative values to drop. The values provided must be either all positive or all negative.}

\item{by}{Columns to group by}

\item{n}{Number of rows to grab}

\item{order_by}{Variable to arrange by}
}
\description{
Choose rows by their ordinal position in a data.table. Grouped data.tables use the ordinal position within the group.
}
\examples{
example_dt <- data.table::data.table(
  x = c(1,2,3,4),
  y = c(4,5,6,7),
  z = c("a","a","a","b"))

example_dt \%>\%
  slice.(1:4)

example_dt \%>\%
  slice.(1, by = z)

example_dt \%>\%
  slice_head.(1, by = z)

example_dt \%>\%
  slice_tail.(1, by = z)

example_dt \%>\%
  slice_max.(order_by = x, by = z)

example_dt \%>\%
  slice_min.(order_by = y, by = z)
}
