% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/relocate.R
\name{relocate.}
\alias{relocate.}
\alias{dt_relocate}
\title{Relocate a column to a new position}
\usage{
relocate.(.df, ..., .before = NULL, .after = NULL)

dt_relocate(.df, ..., .before = NULL, .after = NULL)
}
\arguments{
\item{.df}{A data.frame or data.table}

\item{...}{A selection of columns to move. `tidyselect` compatible.}

\item{.before}{Column to move selection before}

\item{.after}{Column to move selection after}
}
\description{
Move a column or columns to a new position
}
\examples{
test_df <- data.table(
  a = 1:5,
  b = 1:5,
  c = c("a","a","a","b","b"),
  d = c("a","a","a","b","b"))

test_df \%>\%
  relocate.(c, .before = b)

test_df \%>\%
  relocate.(a, b, .after = c)

test_df \%>\%
  relocate.(where(is.numeric), .after = c)
}
