% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ifelse.R
\name{ifelse.}
\alias{ifelse.}
\title{Fast ifelse}
\usage{
ifelse.(conditions, true, false, na = NA)
}
\arguments{
\item{conditions}{Conditions to test on}

\item{true}{Values to return if conditions evaluate to TRUE}

\item{false}{Values to return if conditions evaluate to FALSE}

\item{na}{Value to return if an element of test is NA.}
}
\description{
\code{ifelse.()} utilizes \code{data.table::fifelse()} in the background, but automatically
converts NAs to their proper type.
}
\examples{
x <- 1:5
ifelse.(x < 3, 1, 0)

# Can also be used inside of mutate.()
test_df <- data.table(x = x)

test_df \%>\%
  mutate.(new_col = ifelse.(x < 3, 1, 0))
}
